/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.FormaCorrecao;
import br.com.elotech.tributos.domain.acrescimo.IndiceComposto;
import br.com.elotech.tributos.domain.acrescimo.ValorIndice;
import br.com.elotech.tributos.domain.parcelamento.AtualizacaoMonetaria;
import br.com.elotech.tributos.domain.parcelamento.EstornoAtualizacaoMonetaria;
import br.com.elotech.tributos.domain.parcelamento.TipoAtualizacaoMonetaria;
import br.com.elotech.tributos.dto.atualizacaomonetariaparcelamento.AtualizacaoMonetariaItemDTO;
import br.com.elotech.tributos.dto.atualizacaomonetariaparcelamento.AtualizacaoMonetariaParcelamentoParams;
import br.com.elotech.tributos.dto.atualizacaomonetariaparcelamento.FiltroItensAtualizacaoMonetariaDTO;
import br.com.elotech.tributos.dto.atualizacaomonetariaparcelamento.TotalizadorAtualizacaoMonetariaDTO;
import br.com.elotech.tributos.repository.atualizacaomonetaria.AtualizacaoMonetariaParcelamentoRepository;
import br.com.elotech.tributos.repository.parcelamento.AtualizacaoMonetariaRepository;
import br.com.elotech.tributos.service.EntidadeCorrecaoService;
import br.com.elotech.tributos.service.EstornoAtualizacaoMonetariaService;
import br.com.elotech.tributos.service.acrescimo.calculo.correcao.CalculoCorrecaoUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class AtualizacaoMonetariaService
extends CrudService<AtualizacaoMonetaria, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AtualizacaoMonetariaService.class);
    private final AtualizacaoMonetariaRepository atualizacaoMonetariaRepository;
    private final AtualizacaoMonetariaParcelamentoRepository atualizacaoMonetariaParcelamentoRepository;
    private final EstornoAtualizacaoMonetariaService estornoAtualizacaoMonetariaService;
    private final EntidadeCorrecaoService entidadeCorrecaoService;
    private static final BigDecimal TOTALIZADOR_MARGEM_ARREDONDAMENTO = new BigDecimal("0.001");

    public boolean existsAtualizacaoRealizadaNoMes(Long entidade, Long exercicio, Long mes, TipoAtualizacaoMonetaria tipo) {
        return this.atualizacaoMonetariaRepository.existsByEntidadeEqualsAndAnoEqualsAndMesAndTipoAndEstornadoEquals(entidade, Integer.valueOf(exercicio.intValue()), Integer.valueOf(mes.intValue()), tipo, Boolean.FALSE);
    }

    public boolean existsDebitoByFiltro(AtualizacaoMonetariaParcelamentoParams params) {
        return this.atualizacaoMonetariaParcelamentoRepository.existsByFiltro(params);
    }

    public boolean possuiItensEstornados(Long id) {
        return this.atualizacaoMonetariaRepository.existsItensEstornadosById(id);
    }

    public AtualizacaoMonetaria marcarComoEstornado(Long idEstornoAtualizacaoMonetaria) {
        EstornoAtualizacaoMonetaria estorno = (EstornoAtualizacaoMonetaria)this.estornoAtualizacaoMonetariaService.findById((Serializable)idEstornoAtualizacaoMonetaria).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar um estorno com o id %d.", idEstornoAtualizacaoMonetaria)));
        AtualizacaoMonetaria atualizacao = estorno.getAtualizacaoMonetaria();
        atualizacao.setDataEstorno(LocalDateTime.now());
        atualizacao.setUsuarioEstorno(estorno.getUsuario());
        atualizacao.setMotivoEstorno(estorno.getObservacao());
        atualizacao.setEstornado(Boolean.TRUE);
        return (AtualizacaoMonetaria)this.save((EloEntity)atualizacao, null);
    }

    public void delete(Long id) {
        this.findById((Serializable)id).ifPresent(atualizacao -> this.delete((EloEntity)atualizacao, null));
    }

    public Page<AtualizacaoMonetariaItemDTO> searchItensById(Long id, FiltroItensAtualizacaoMonetariaDTO params, Boolean agrupadoPorDebito, Pageable pageable) {
        return this.atualizacaoMonetariaParcelamentoRepository.searchItens(id, params, agrupadoPorDebito, pageable);
    }

    public TotalizadorAtualizacaoMonetariaDTO getTotalizadorAtualizacaoMonetaria(Long id, FiltroItensAtualizacaoMonetariaDTO filtro) {
        TotalizadorAtualizacaoMonetariaDTO dto = this.atualizacaoMonetariaParcelamentoRepository.getTotalizador(id, filtro);
        this.findById((Serializable)id).ifPresent(atualizacao -> this.adjustTotalizadorPercentualParcelaIfArredondamento(dto, atualizacao));
        return dto;
    }

    private void adjustTotalizadorPercentualParcelaIfArredondamento(TotalizadorAtualizacaoMonetariaDTO dto, AtualizacaoMonetaria atualizacaoMonetaria) {
        BigDecimal valorIndiceCorrecao = this.findValorIndiceCorrecao(atualizacaoMonetaria);
        if (valorIndiceCorrecao.compareTo(BigDecimal.ZERO) > 0 && this.isDiferencaTotalizadorDentroDaMargemArredondamento(dto.getPercentualParcela(), valorIndiceCorrecao).booleanValue()) {
            dto.setPercentualParcela(valorIndiceCorrecao);
        }
    }

    private BigDecimal findValorIndiceCorrecao(AtualizacaoMonetaria atualizacaoMonetaria) {
        FormaCorrecao formaCorrecao = this.entidadeCorrecaoService.getEntidadeCorrecao(atualizacaoMonetaria.getEntidade(), Long.valueOf(atualizacaoMonetaria.getAno().longValue()), Optional.empty()).getFormaCorrecao();
        LocalDate dataCorrecaoMensal = this.getDataCorrecaoMensal(atualizacaoMonetaria.getAno(), atualizacaoMonetaria.getMes());
        IndiceComposto indiceComposto = CalculoCorrecaoUtils.getIndiceCompostoByData((FormaCorrecao)formaCorrecao, (LocalDate)dataCorrecaoMensal);
        ValorIndice valorIndiceCorrecao = CalculoCorrecaoUtils.getValorByIndiceCorrecao((IndiceComposto)indiceComposto, (LocalDate)dataCorrecaoMensal, (Boolean)Boolean.FALSE);
        return valorIndiceCorrecao.getValor();
    }

    private Boolean isDiferencaTotalizadorDentroDaMargemArredondamento(BigDecimal percentualAtual, BigDecimal valorIndiceCorrecao) {
        return percentualAtual.compareTo(valorIndiceCorrecao) != 0 && percentualAtual.subtract(valorIndiceCorrecao).abs().compareTo(TOTALIZADOR_MARGEM_ARREDONDAMENTO) <= 0;
    }

    private LocalDate getDataCorrecaoMensal(Integer anoAtualizacaoMonetaria, Integer mesAtualizacaoMonetaria) {
        LocalDate dataBase = LocalDate.of((int)anoAtualizacaoMonetaria, mesAtualizacaoMonetaria, 1);
        return dataBase.minusYears(1L);
    }

    @Generated
    public AtualizacaoMonetariaService(AtualizacaoMonetariaRepository atualizacaoMonetariaRepository, AtualizacaoMonetariaParcelamentoRepository atualizacaoMonetariaParcelamentoRepository, EstornoAtualizacaoMonetariaService estornoAtualizacaoMonetariaService, EntidadeCorrecaoService entidadeCorrecaoService) {
        this.atualizacaoMonetariaRepository = atualizacaoMonetariaRepository;
        this.atualizacaoMonetariaParcelamentoRepository = atualizacaoMonetariaParcelamentoRepository;
        this.estornoAtualizacaoMonetariaService = estornoAtualizacaoMonetariaService;
        this.entidadeCorrecaoService = entidadeCorrecaoService;
    }
}

