/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Certificado;
import br.com.elotech.tributos.util.XMLDocumentBuilderFactory;
import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xml.security.Init;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.ElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

@Service
public class AssinaturaXMLService {
    @Generated
    private static final Logger log = LogManager.getLogger(AssinaturaXMLService.class);
    private static final String SIGNATURE_METHOD = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    private static final String[] TRANSFORM_LIST = new String[]{"http://www.w3.org/2000/09/xmldsig#enveloped-signature", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315"};
    private static final String DIGEST_METHOD = "http://www.w3.org/2000/09/xmldsig#sha1";

    public String assinar(String xml, Certificado certificado, String uri, String tagToInsertSign) {
        String signedXML = null;
        try {
            Field f = XMLUtils.class.getDeclaredField("ignoreLineBreaks");
            f.setAccessible(true);
            f.set(null, Boolean.TRUE);
            Init.init();
            ElementProxy.setDefaultPrefix((String)"http://www.w3.org/2000/09/xmldsig#", (String)"");
            Document doc = this.getDocumentBuilder().parse(new InputSource(new StringReader(xml)));
            Element tagToSign = (Element)doc.getElementsByTagName(uri).item(0);
            Element tagToInsert = (Element)doc.getElementsByTagName(tagToInsertSign).item(0);
            if (tagToSign == null) {
                throw new EloValidationException("Tag n\u00e3o encontrada no XML: " + uri);
            }
            if (tagToInsert == null) {
                throw new EloValidationException("Tag para inserir assinatura n\u00e3o encontrada no XML: " + tagToInsertSign);
            }
            if (tagToSign.hasAttribute("Id")) {
                tagToSign.setIdAttribute("Id", true);
            }
            XMLSignature sig = new XMLSignature(doc, null, SIGNATURE_METHOD);
            tagToInsert.appendChild(sig.getElement());
            Transforms transforms = this.criarTransformacoes(TRANSFORM_LIST, doc);
            String uriReference = "#" + tagToSign.getAttribute("Id");
            sig.addDocument((String)((Object)Optional.ofNullable(uriReference).orElse((CallSite)((Object)""))), transforms, DIGEST_METHOD);
            sig.addKeyInfo(certificado.getX509Certificate());
            sig.sign(certificado.getPrivateKey());
            signedXML = this.getDocString(doc);
        }
        catch (Exception ex) {
            log.error("Erro ao assinar xml", (Throwable)ex);
        }
        return signedXML;
    }

    private String getDocString(Document doc) throws TransformerFactoryConfigurationError, TransformerException, UnsupportedEncodingException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TransformerFactory tf = TransformerFactory.newInstance();
        tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer trans = tf.newTransformer();
        trans.setOutputProperty("encoding", "UTF-8");
        trans.transform(new DOMSource(doc), new StreamResult(os));
        return os.toString("UTF-8");
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        return new XMLDocumentBuilderFactory().getDocumentBuilder();
    }

    private Transforms criarTransformacoes(String[] transformList, Document doc) throws TransformationException {
        Transforms transforms = new Transforms(doc);
        for (String transformUri : transformList) {
            transforms.addTransform(transformUri);
        }
        return transforms;
    }

    @Generated
    public AssinaturaXMLService() {
    }
}

