/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.ArquivoJasper;
import br.com.elotech.tributos.dto.ArquivoJasperResponseDTO;
import br.com.elotech.tributos.enums.TipoArquivoJasper;
import br.com.elotech.tributos.exception.ArquivoJasperNotFoundException;
import br.com.elotech.tributos.repository.ArquivoJasperRepository;
import java.util.Objects;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ArquivoJasperService
extends CrudService<ArquivoJasper, Long> {
    private final ArquivoJasperRepository arquivoJasperRepository;

    public ArquivoJasper buscarPorId(Long id) {
        return (ArquivoJasper)this.arquivoJasperRepository.findById((Object)id).orElseThrow(() -> new ArquivoJasperNotFoundException(String.format("N\u00e3o foi encontrado nenhum arquivo com o id %d", id)));
    }

    public Page<ArquivoJasperResponseDTO> listar(String search, Pageable pageable) {
        return this.findByRsql(search, pageable).map(ArquivoJasperResponseDTO::from);
    }

    public ArquivoJasper buscarArquivoJasperPorTipo(TipoArquivoJasper tipoArquivoJasper) {
        return this.arquivoJasperRepository.findByTipoArquivoJasper(tipoArquivoJasper).orElse(null);
    }

    public ArquivoJasper updateArquivo(ArquivoJasper entity) {
        ArquivoJasper arquivoJasper = this.buscarPorId(entity.getId());
        if (Objects.nonNull(entity.getArquivo())) {
            arquivoJasper.setArquivo(entity.getArquivo());
            this.popularEntidade(entity, arquivoJasper);
        } else {
            this.popularEntidade(entity, arquivoJasper);
        }
        return (ArquivoJasper)this.arquivoJasperRepository.save((Object)arquivoJasper);
    }

    private void popularEntidade(ArquivoJasper entity, ArquivoJasper arquivoJasper) {
        arquivoJasper.setNomeArquivo(entity.getNomeArquivo());
        arquivoJasper.setTipoArquivoJasper(entity.getTipoArquivoJasper());
        arquivoJasper.setUsuario(entity.getUsuario());
        arquivoJasper.setDataAlteracao(entity.getDataAlteracao());
    }

    @Generated
    public ArquivoJasperService(ArquivoJasperRepository arquivoJasperRepository) {
        this.arquivoJasperRepository = arquivoJasperRepository;
    }
}

