/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.SituacaoMobiliario;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliario;
import br.com.elotech.tributos.dto.AlvaraLocalizacaoDTO;
import br.com.elotech.tributos.dto.DocumentoDTO;
import br.com.elotech.tributos.dto.DocumentoSearchInitialValuesDTO;
import br.com.elotech.tributos.dto.GeracaoDocumentoDTO;
import br.com.elotech.tributos.repository.CadastroGeralRepository;
import br.com.elotech.tributos.service.CadastroMobiliarioService;
import br.com.elotech.tributos.service.DocumentoService;
import br.com.elotech.tributos.service.GeraDocumentoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.PessoaService;
import br.com.elotech.tributos.util.FileUtils;
import java.io.Serializable;
import java.util.Objects;
import javax.validation.Valid;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AlvaraLocalizacaoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlvaraLocalizacaoService.class);
    private final DocumentoService documentoService;
    private final ParametroGeralService parametroGeralService;
    private final CadastroMobiliarioService cadastroMobiliarioService;
    private final GeraDocumentoService geraDocumentoService;
    private final CadastroGeralRepository cadastroGeralRepository;

    public AlvaraLocalizacaoService(DocumentoService documentoService, ParametroGeralService parametroGeralService, CadastroMobiliarioService cadastroMobiliarioService, GeraDocumentoService geraDocumentoService, PessoaService pessoaService, CadastroGeralRepository cadastroGeralRepository) {
        this.documentoService = documentoService;
        this.parametroGeralService = parametroGeralService;
        this.cadastroMobiliarioService = cadastroMobiliarioService;
        this.geraDocumentoService = geraDocumentoService;
        this.cadastroGeralRepository = cadastroGeralRepository;
    }

    public AlvaraLocalizacaoDTO getInitialValues(@Valid DocumentoSearchInitialValuesDTO documentoSearchInitialValuesDTO) {
        CadastroMobiliario cadastroMobiliario;
        Boolean isPorContribuinte = documentoSearchInitialValuesDTO.getTipoFiltro().isPorContribuinte();
        AlvaraLocalizacaoDTO valoresIniciais = new AlvaraLocalizacaoDTO();
        valoresIniciais.setPessoa(isPorContribuinte != false ? this.getContribuinteFromRequest(documentoSearchInitialValuesDTO) : this.getPessoaFromRequest(documentoSearchInitialValuesDTO));
        if (documentoSearchInitialValuesDTO.getIdCadastro() != null && Objects.nonNull(cadastroMobiliario = (CadastroMobiliario)this.cadastroMobiliarioService.findOne((Serializable)documentoSearchInitialValuesDTO.getIdCadastro()))) {
            valoresIniciais.setExercicioProcesso(cadastroMobiliario.getExercicioProcessoAbertura());
            valoresIniciais.setIdProcesso(cadastroMobiliario.getIdProcessoAbertura());
        }
        return valoresIniciais;
    }

    private Pessoa getContribuinteFromRequest(DocumentoSearchInitialValuesDTO documentoSearchInitialValuesDTO) {
        return documentoSearchInitialValuesDTO.getContribuinte();
    }

    private Pessoa getPessoaFromRequest(DocumentoSearchInitialValuesDTO documentoSearchInitialValuesDTO) {
        return ((CadastroGeral)this.cadastroGeralRepository.findById((Object)documentoSearchInitialValuesDTO.getIdCadastro()).orElseThrow(() -> new EloValidationException(String.format("Cadastro Geral %d n\u00e3o encontrado", documentoSearchInitialValuesDTO.getIdCadastro())))).getPessoa();
    }

    private void validateSituacaoMobiliario(SituacaoMobiliario situacaoMobiliario, String descricaoTipoCadastro, Long cadastroGeral) {
        if (situacaoMobiliario.getTipoSituacaoMobiliario().isDesatualizado().booleanValue()) {
            throw new EloValidationException(String.format("Cadastro %s: %d est\u00e1 com situa\u00e7\u00e3o \"%s\"!", descricaoTipoCadastro, cadastroGeral, situacaoMobiliario.getDescricao()));
        }
    }

    public DocumentoDTO save(@Valid AlvaraLocalizacaoDTO alvaraLocalizacaoDTO) {
        CadastroMobiliario cadastroMobiliario = this.cadastroMobiliarioService.findCadastroMobiliarioById(alvaraLocalizacaoDTO.getIdCadastro());
        this.validateSituacaoMobiliario(cadastroMobiliario.getSituacaoAtual(), cadastroMobiliario.getTipoCadastro().getDescricao(), cadastroMobiliario.getCadastroGeral());
        Documento documento = this.geraDocumentoService.getDocumentoAndValida(GeracaoDocumentoDTO.from((AlvaraLocalizacaoDTO)alvaraLocalizacaoDTO, (CadastroGeral)cadastroMobiliario));
        documento.setSituacaoCadastral(cadastroMobiliario.getSituacaoAtual().getDescricao());
        documento.setSubTipo(alvaraLocalizacaoDTO.getTipoAlvara().getValue());
        documento.setProcessoSei(alvaraLocalizacaoDTO.getProcessoSei());
        documento.setObservacao(alvaraLocalizacaoDTO.getObservacao());
        log.debug("SAVE - Document type possuiCabecalho: {}", (Object)documento.getDocumentoTipo().getPossuiCabecalho());
        log.debug("SAVE - Document type possuiRodape: {}", (Object)documento.getDocumentoTipo().getPossuiRodape());
        log.debug("SAVE - DTO cabecalho: '{}'", (Object)alvaraLocalizacaoDTO.getCabecalho());
        log.debug("SAVE - DTO rodape: '{}'", (Object)alvaraLocalizacaoDTO.getRodape());
        log.debug("SAVE - DTO observacao: '{}'", (Object)alvaraLocalizacaoDTO.getObservacao());
        if (Boolean.TRUE.equals(documento.getDocumentoTipo().getPossuiCabecalho())) {
            byte[] cabecalhoBytes = FileUtils.safeTextToBytes((String)alvaraLocalizacaoDTO.getCabecalho());
            documento.setCabecalho(cabecalhoBytes);
            log.debug("SAVE - Set cabecalho bytes length: {}", cabecalhoBytes != null ? Integer.valueOf(cabecalhoBytes.length) : "null");
        }
        if (Boolean.TRUE.equals(documento.getDocumentoTipo().getPossuiRodape())) {
            byte[] rodapeBytes = FileUtils.safeTextToBytes((String)alvaraLocalizacaoDTO.getRodape());
            documento.setRodape(rodapeBytes);
            log.debug("SAVE - Set rodape bytes length: {}", rodapeBytes != null ? Integer.valueOf(rodapeBytes.length) : "null");
        }
        Documento saved = (Documento)this.documentoService.save((EloEntity)documento, null);
        this.atualizaCadastroMobiliario(cadastroMobiliario, saved);
        return DocumentoDTO.from((Documento)documento);
    }

    private void atualizaCadastroMobiliario(CadastroMobiliario cadastroMobiliario, Documento documento) {
        if (this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.ATUALIZA_ALVARA_MOBILIARIO).booleanValue()) {
            cadastroMobiliario.setNumeroAlvara(documento.getDocumento());
            cadastroMobiliario.setExercicioAlvara(documento.getExercicio());
            if (this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.ATUALIZA_ALVARA_DATA).booleanValue()) {
                cadastroMobiliario.setDataAlvara(documento.getDataEmissao());
                cadastroMobiliario.setDataValidadeAlvara(documento.getDataValidade());
            }
            this.cadastroMobiliarioService.save((EloEntity)cadastroMobiliario, null);
        }
    }

    public DocumentoDTO editar(Long id, @Valid AlvaraLocalizacaoDTO dto) {
        Documento documentoExists = this.documentoService.findDocumentoDomainById(id);
        CadastroMobiliario cadastroMobiliario = this.cadastroMobiliarioService.findCadastroMobiliarioById(dto.getIdCadastro());
        this.validateSituacaoMobiliario(cadastroMobiliario.getSituacaoAtual(), cadastroMobiliario.getTipoCadastro().getDescricao(), cadastroMobiliario.getCadastroGeral());
        this.geraDocumentoService.validateDocumento(documentoExists.getDocumentoTipo(), documentoExists.getPessoa(), documentoExists.getCadastroGeral(), dto.getIdProcesso(), null, null);
        documentoExists.setIdProcesso(dto.getIdProcesso());
        documentoExists.setExercicioProcesso(dto.getExercicioProcesso());
        documentoExists.setProcessoSei(dto.getProcessoSei());
        documentoExists.setPessoa(dto.getPessoa());
        documentoExists.setSubTipo(dto.getTipoAlvara().getValue());
        documentoExists.setObservacao(dto.getObservacao());
        log.debug("Document type possuiCabecalho: {}", (Object)documentoExists.getDocumentoTipo().getPossuiCabecalho());
        log.debug("Document type possuiRodape: {}", (Object)documentoExists.getDocumentoTipo().getPossuiRodape());
        log.debug("DTO cabecalho: '{}'", (Object)dto.getCabecalho());
        log.debug("DTO rodape: '{}'", (Object)dto.getRodape());
        log.debug("DTO observacao: '{}'", (Object)dto.getObservacao());
        if (Boolean.TRUE.equals(documentoExists.getDocumentoTipo().getPossuiCabecalho())) {
            byte[] cabecalhoBytes = FileUtils.safeTextToBytes((String)dto.getCabecalho());
            documentoExists.setCabecalho(cabecalhoBytes);
            log.debug("Set cabecalho bytes length: {}", cabecalhoBytes != null ? Integer.valueOf(cabecalhoBytes.length) : "null");
        }
        if (Boolean.TRUE.equals(documentoExists.getDocumentoTipo().getPossuiRodape())) {
            byte[] rodapeBytes = FileUtils.safeTextToBytes((String)dto.getRodape());
            documentoExists.setRodape(rodapeBytes);
            log.debug("Set rodape bytes length: {}", rodapeBytes != null ? Integer.valueOf(rodapeBytes.length) : "null");
        }
        Documento documentoSaved = (Documento)this.documentoService.save((EloEntity)documentoExists, null);
        return DocumentoDTO.from((Documento)documentoSaved);
    }
}

