/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.security;

import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.multitenant.utils.ResponseUtils;
import br.com.elotech.tributos.security.SecurityUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.filter.OncePerRequestFilter;

public class WebIssSecurityFilter
extends OncePerRequestFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebIssSecurityFilter.class);
    private final ObjectMapper objectMapper;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        if (!SecurityUtils.isUsuarioIntegracaoWebIss().booleanValue()) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        log.debug("Token identificado como usu\u00e1rio de integra\u00e7\u00e3o da WebIss");
        Optional tenantTokenWebIss = SecurityUtils.getTenantIntegracaoWebIss();
        if (tenantTokenWebIss.isEmpty()) {
            log.error("Token de integra\u00e7\u00e3o da WebIss sem tenant");
            ResponseUtils.sendError((HttpServletResponse)response, (ObjectMapper)this.objectMapper, (HttpStatus)HttpStatus.UNAUTHORIZED, (String)"N\u00e3o foi poss\u00edvel identificar o tenant do token informado.");
            return;
        }
        String tenantRequisicaoWebIss = TenantContextHolder.getCurrentTenantId();
        if (!tenantRequisicaoWebIss.equals(tenantTokenWebIss.get())) {
            log.error("Token da WebIss do tenant {} tentando acessar dados do tenant {}", tenantTokenWebIss.get(), (Object)tenantRequisicaoWebIss);
            String mensagem = String.format("O token tem acesso ao tenant %s mas est\u00e1 tentando acessar dados do tenant %s.", tenantTokenWebIss.get(), tenantRequisicaoWebIss);
            ResponseUtils.sendError((HttpServletResponse)response, (ObjectMapper)this.objectMapper, (HttpStatus)HttpStatus.FORBIDDEN, (String)mensagem);
            return;
        }
        String uriWithoutContextPathWebIss = request.getRequestURI().replace(request.getContextPath(), "");
        if (!uriWithoutContextPathWebIss.startsWith("/api/webiss/cadastro")) {
            log.error("Token do tenant {} tentando acessar recursos que n\u00e3o s\u00e3o da WebIss. Recurso acessado: {}", tenantTokenWebIss.get(), (Object)request.getRequestURI());
            String mensagemFormatada = String.format("Esse token s\u00f3 tem permiss\u00e3o para acessar os recursos da WebIss e est\u00e1 tentando acessar o recurso %s.", uriWithoutContextPathWebIss);
            ResponseUtils.sendError((HttpServletResponse)response, (ObjectMapper)this.objectMapper, (HttpStatus)HttpStatus.FORBIDDEN, (String)mensagemFormatada);
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    @Generated
    public WebIssSecurityFilter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

