/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.security;

import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.multitenant.utils.ResponseUtils;
import br.com.elotech.tributos.security.SecurityUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.filter.OncePerRequestFilter;

public class IntegracaoProcuradoriaSecurityFilter
extends OncePerRequestFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegracaoProcuradoriaSecurityFilter.class);
    private final ObjectMapper objectMapper;
    private final String URI_AUTHORIZED = "/api/integracaoprocuradoria";

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!SecurityUtils.isUsuarioIntegracaoProcuradoria().booleanValue()) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        log.debug("Token identificado como usu\u00e1rio de integra\u00e7\u00e3o para procuradoria");
        Optional tenantToken = SecurityUtils.getTenantIntegracaoProcuradoria();
        if (tenantToken.isEmpty()) {
            log.error("Token de integra\u00e7\u00e3o sem tenant");
            ResponseUtils.sendError((HttpServletResponse)response, (ObjectMapper)this.objectMapper, (HttpStatus)HttpStatus.UNAUTHORIZED, (String)"N\u00e3o foi poss\u00edvel identificar o tenant do token informado.");
            return;
        }
        String currentTenantId = TenantContextHolder.getCurrentTenantId();
        if (!currentTenantId.equals(tenantToken.get())) {
            String mensagemFormatada = "Esse token s\u00f3 tem permiss\u00e3o para acessar os recursos de integra\u00e7\u00e3o do tenant " + (String)tenantToken.get();
            ResponseUtils.sendError((HttpServletResponse)response, (ObjectMapper)this.objectMapper, (HttpStatus)HttpStatus.FORBIDDEN, (String)mensagemFormatada);
            return;
        }
        String urlWithoutContextPath = request.getRequestURI().replace(request.getContextPath(), "");
        if (!urlWithoutContextPath.startsWith("/api/integracaoprocuradoria")) {
            String mensagemFormatada = "Esse token s\u00f3 tem permiss\u00e3o para acessar os recursos de integra\u00e7\u00e3o de procuradoria. Consulte documenta\u00e7\u00e3o.";
            ResponseUtils.sendError((HttpServletResponse)response, (ObjectMapper)this.objectMapper, (HttpStatus)HttpStatus.FORBIDDEN, (String)mensagemFormatada);
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    @Generated
    public IntegracaoProcuradoriaSecurityFilter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

