/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.webiss;

import br.com.elotech.tributos.dto.webiss.CadastroPessoaJuridicaWebIssDTO;
import br.com.elotech.tributos.service.webiss.CadastroMobiliarioWebIssService;
import io.swagger.v3.oas.annotations.Operation;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/webiss/cadastro"})
public class WebIssCadastroResource {
    private final CadastroMobiliarioWebIssService cadastroMobiliarioWebIssService;

    @Operation(summary="Retorna uma lista de cadastro Mobili\u00e1rio baseado em um CNPJ")
    @GetMapping(value={"/{cnpjCpf}"})
    public ResponseEntity<List<CadastroPessoaJuridicaWebIssDTO>> findByCadastroGeralWebIss(@PathVariable String cnpjCpf) {
        return ResponseEntity.ok((Object)this.cadastroMobiliarioWebIssService.findCadastroMobiliarioByCnpj(cnpjCpf));
    }

    @Operation(summary="Retorna uma lista de CNPJs alterados ou inclu\u00eddos no p\u00e9riodo informado")
    @GetMapping(value={"/alterados-incluidos"})
    public ResponseEntity<List<String>> findCadastroMobiliarioAlteradosOuIncluidos(@RequestParam(value="dataInicial") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime dataHoraInicial, @RequestParam(value="dataFinal") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime dataHoraFinal) {
        return ResponseEntity.ok((Object)this.cadastroMobiliarioWebIssService.findCadastroGeralAlteradosWebIss(dataHoraInicial, dataHoraFinal));
    }

    @Generated
    public WebIssCadastroResource(CadastroMobiliarioWebIssService cadastroMobiliarioWebIssService) {
        this.cadastroMobiliarioWebIssService = cadastroMobiliarioWebIssService;
    }
}

