/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.relatoriogerencialarrecadacao;

import br.com.elotech.tributos.dto.relatoriogerencial.LancamentoArrecadacaoDTO;
import br.com.elotech.tributos.service.relatoriogerencial.lancamentoarrecadacao.LancamentoArrecadacaoService;
import lombok.Generated;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/relatoriogerencial/lancamento-arrecadacao"})
public class LancamentoArrecadacaoResource {
    private final LancamentoArrecadacaoService lancamentoArrecadacaoService;

    @PostMapping(value={"/{exercicio}/{mesAnalise}"})
    public ResponseEntity<Void> lancamentoArrecadacao(@PathVariable(value="exercicio") Long exercicio, @PathVariable(value="mesAnalise") Long mesAnalise) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException {
        this.lancamentoArrecadacaoService.startJobLancamentoArrecadacao(exercicio, mesAnalise);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/resumo/{exercicio}"})
    public ResponseEntity<LancamentoArrecadacaoDTO> findResumoLancamentoArrecadacao(@PathVariable(value="exercicio") Long exercicio) {
        LancamentoArrecadacaoDTO dto = this.lancamentoArrecadacaoService.findResumoLancamentoArrecadacao(exercicio);
        return ResponseEntity.ok((Object)dto);
    }

    @Generated
    public LancamentoArrecadacaoResource(LancamentoArrecadacaoService lancamentoArrecadacaoService) {
        this.lancamentoArrecadacaoService = lancamentoArrecadacaoService;
    }
}

