/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.relatoriogerencialarrecadacao;

import br.com.elotech.tributos.dto.relatoriogerencial.ResumoAnaliseArrecadacaoDTO;
import br.com.elotech.tributos.service.relatoriogerencial.acompanhamentoperiodo.AcompanhamentoPeriodoJobStarter;
import br.com.elotech.tributos.service.relatoriogerencial.acompanhamentoperiodo.AcompanhamentoPeriodoService;
import java.util.List;
import lombok.Generated;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/relatoriogerencial/acompanhamento-periodo"})
public class AcompanhamentoPeriodoResource {
    private final AcompanhamentoPeriodoJobStarter acompanhamentoPeriodoJobStarter;
    private final AcompanhamentoPeriodoService acompanhamentoPeriodoService;

    @PostMapping(value={"/{exercicio}/{mesAnalise}/{dia}"})
    public ResponseEntity<Void> acompanhamentoDiario(@PathVariable(value="exercicio") Long exercicio, @PathVariable(value="mesAnalise") Long mesAnalise, @PathVariable(value="dia") Long dia) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException {
        this.acompanhamentoPeriodoJobStarter.startJob(exercicio, mesAnalise, dia.longValue());
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/{exercicio}/{mesAnalise}"})
    public ResponseEntity<Void> acompanhamentoMensal(@PathVariable(value="exercicio") Long exercicio, @PathVariable(value="mesAnalise") Long mesAnalise) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException {
        this.acompanhamentoPeriodoJobStarter.startJob(exercicio, mesAnalise, 0L);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/resumo/{exercicio}/{mesAnalise}"})
    public ResponseEntity<List<ResumoAnaliseArrecadacaoDTO>> findResumoAnaliseArrecadacao(@PathVariable(value="exercicio") Long exercicio, @PathVariable(value="mesAnalise") Long mesAnalise) {
        List dto = this.acompanhamentoPeriodoService.findResumoAnaliseArrecadacao(exercicio, mesAnalise);
        return ResponseEntity.ok((Object)dto);
    }

    @Generated
    public AcompanhamentoPeriodoResource(AcompanhamentoPeriodoJobStarter acompanhamentoPeriodoJobStarter, AcompanhamentoPeriodoService acompanhamentoPeriodoService) {
        this.acompanhamentoPeriodoJobStarter = acompanhamentoPeriodoJobStarter;
        this.acompanhamentoPeriodoService = acompanhamentoPeriodoService;
    }
}

