/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.projeto.construtora;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.projeto.construtora.Construtora;
import br.com.elotech.tributos.dto.projeto.construtora.ConstrutoraDTO;
import br.com.elotech.tributos.service.projeto.construtora.ConstrutoraService;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/construtora"})
public class ConstrutoraResource
extends CrudResource<Construtora, Long> {
    private final ConstrutoraService construtoraService;

    @GetMapping(value={"/dto"})
    public ResponseEntity<Page<ConstrutoraDTO>> findByRsqlConstrutoraDTO(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.construtoraService.findByRsqlConstrutoraDTO(search, pageable));
    }

    @GetMapping(value={"/dto/{id}"})
    public ResponseEntity<ConstrutoraDTO> findOneConstrutoraDTO(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.construtoraService.findOneConstrutoraDTO(id));
    }

    @PostMapping(value={"/dto"})
    public ResponseEntity<ConstrutoraDTO> save(@RequestBody @Valid ConstrutoraDTO dto, Authentication authentication) {
        Construtora saved = Objects.requireNonNull((Construtora)this.save((EloEntity)dto.toEntity(), authentication).getBody());
        return ResponseEntity.ok((Object)ConstrutoraDTO.from((Construtora)saved, (List)this.construtoraService.findProfissionaisByConstrutora(saved)));
    }

    @PutMapping(value={"/dto/{id}"})
    public ResponseEntity<ConstrutoraDTO> update(@RequestBody @Valid ConstrutoraDTO dto, @PathVariable(value="id") Long id, Authentication authentication) {
        Construtora saved = Objects.requireNonNull((Construtora)this.update((EloEntity)dto.toEntity(), (Serializable)id, authentication).getBody());
        return ResponseEntity.ok((Object)ConstrutoraDTO.from((Construtora)saved, (List)this.construtoraService.findProfissionaisByConstrutora(saved)));
    }

    @Generated
    public ConstrutoraResource(ConstrutoraService construtoraService) {
        this.construtoraService = construtoraService;
    }
}

