/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.memoria;

import br.com.elotech.tributos.dto.memoria.CadastroGeralMemoriaDTO;
import br.com.elotech.tributos.dto.memoria.CadastroImobiliarioMemoriaDTO;
import br.com.elotech.tributos.dto.memoria.MemoriaCadastroDTO;
import br.com.elotech.tributos.service.memoria.MemoriaCadastroService;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/memoria-cadastros"})
public class MemoriaCadastroResource {
    private final MemoriaCadastroService service;

    @GetMapping(value={"/search"})
    public ResponseEntity<Page<MemoriaCadastroDTO>> search(@RequestParam String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.service.findByRsql(search, pageable).map(MemoriaCadastroDTO::from));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<MemoriaCadastroDTO> findByIdDTO(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.service.findByIdDTO(id));
    }

    @GetMapping(value={"/{id}/cadastros"})
    public ResponseEntity<Page<CadastroGeralMemoriaDTO>> searchCadastros(@PathVariable(value="id") Long id, @RequestParam(value="search", required=false) String search, Pageable pageable) {
        Page result = this.service.searchCadastros(id, search, pageable);
        return ResponseEntity.ok((Object)result);
    }

    @GetMapping(value={"by-cadastro/{idMemoria}/{tipoCadastro}/{cadastroGeral}"})
    public ResponseEntity<MemoriaCadastroDTO> findByCadastroDTO(@PathVariable Long idMemoria, @PathVariable Long tipoCadastro, @PathVariable Long cadastroGeral) {
        return ResponseEntity.ok((Object)this.service.findByCadastroDTO(idMemoria, tipoCadastro, cadastroGeral));
    }

    @PutMapping(value={"/imobiliario"})
    public ResponseEntity<CadastroImobiliarioMemoriaDTO> update(@RequestBody CadastroImobiliarioMemoriaDTO dto) {
        return ResponseEntity.ok((Object)this.service.saveCadastroImobiliarioDTO(dto));
    }

    @Generated
    public MemoriaCadastroResource(MemoriaCadastroService service) {
        this.service = service;
    }
}

