/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaoprocuradoria;

import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.dto.ExtratoDebitoDTO;
import br.com.elotech.tributos.dto.integracaoprocuradoria.FiltroExtratoDebitoProcuradoriaDTO;
import br.com.elotech.tributos.dto.itbi.CadastroGeralCidadaoFiltroDTO;
import br.com.elotech.tributos.dto.itbi.CadastroGeralCidadaoMobileDTO;
import br.com.elotech.tributos.service.AtendimentoService;
import br.com.elotech.tributos.service.DocumentoService;
import br.com.elotech.tributos.service.mobile.CadastroGeralCidadaoMobileService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Generated;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/integracaoprocuradoria"})
@Tag(name="Integra\u00e7\u00e3o com Procuradoria", description="APIs de integra\u00e7\u00e3o com o sistema da procuradoria")
public class IntegracaoProcuradoriaResource {
    private final CadastroGeralCidadaoMobileService cadastroGeralCidadaoMobileService;
    private final AtendimentoService atendimentoService;
    private final DocumentoService documentoService;
    private static final String TIPO_CADASTRO_DESCRICAO = "1 - Imobili\u00e1rio / 2 - Mobili\u00e1rio / 3 - Rural / 4 - Cemit\u00e9rio / 5 - \u00c1gua Esgoto / 9 - Avulso";

    @Operation(summary="Retorna uma lista de d\u00e9bitos por cadastro")
    @GetMapping(path={"/debitos/{tipoCadastro}/{cadastroGeral}"})
    public ResponseEntity<Page<ExtratoDebitoDTO>> getDebitosExtrato(@Parameter(description="1 - Imobili\u00e1rio / 2 - Mobili\u00e1rio / 3 - Rural / 4 - Cemit\u00e9rio / 5 - \u00c1gua Esgoto / 9 - Avulso") @PathVariable Long tipoCadastro, @Parameter(description="N\u00famero do Cadastro") @PathVariable Long cadastroGeral, @ParameterObject FiltroExtratoDebitoProcuradoriaDTO filtroDTO, @ParameterObject Pageable pageable) {
        Page extratoDebitos = this.atendimentoService.findExtratoDebitos(filtroDTO.toFiltroExtratoDebitoDTO(tipoCadastro, cadastroGeral), pageable);
        return ResponseEntity.ok((Object)extratoDebitos);
    }

    @Operation(summary="Retorna uma lista de d\u00e9bitos por certid\u00e3o")
    @GetMapping(path={"/debitos/certidao/{numeroCda}/{anoCda}"})
    public ResponseEntity<Page<ExtratoDebitoDTO>> getDebitosExtratoByCertidao(@Parameter(description="N\u00famero da Certid\u00e3o") @PathVariable Long numeroCda, @Parameter(description="Ano da Certid\u00e3o") @PathVariable Long anoCda, @ParameterObject FiltroExtratoDebitoProcuradoriaDTO filtroDTO, @ParameterObject Pageable pageable) {
        Documento documento = this.documentoService.getCdaByExercicioDocumento(anoCda, numeroCda);
        filtroDTO.setExercicioCda(anoCda.toString());
        filtroDTO.setNumeroCda(numeroCda.toString());
        Page extratoDebitos = this.atendimentoService.findExtratoDebitos(filtroDTO.toFiltroExtratoDebitoDTO(documento.getTipoCadastro().getValue(), documento.getCadastroGeral().getCadastroGeral()), pageable);
        return ResponseEntity.ok((Object)extratoDebitos);
    }

    @Operation(summary="Retorna uma lista de cadastros")
    @GetMapping(path={"/cadastros/{cpfCnpj}"})
    public ResponseEntity<Page<CadastroGeralCidadaoMobileDTO>> getCadastros(@PathVariable String cpfCnpj, @ParameterObject Pageable pageable) {
        return ResponseEntity.ok((Object)this.cadastroGeralCidadaoMobileService.getCadastrosCidadao(new CadastroGeralCidadaoFiltroDTO(cpfCnpj), pageable));
    }

    @Generated
    public IntegracaoProcuradoriaResource(CadastroGeralCidadaoMobileService cadastroGeralCidadaoMobileService, AtendimentoService atendimentoService, DocumentoService documentoService) {
        this.cadastroGeralCidadaoMobileService = cadastroGeralCidadaoMobileService;
        this.atendimentoService = atendimentoService;
        this.documentoService = documentoService;
    }
}

