/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaoimply;

import br.com.elotech.tributos.dto.BloquetoDTO;
import br.com.elotech.tributos.dto.DebitoDTO;
import br.com.elotech.tributos.params.CadastroGeralParams;
import br.com.elotech.tributos.params.GeraBloquetoParams;
import br.com.elotech.tributos.service.AiseBloquetoService;
import br.com.elotech.tributos.service.AiseDebitoService;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/integracao-imply/boleto"})
public class BoletoImplyResource {
    private final AiseDebitoService aiseDebitoService;
    private final AiseBloquetoService aiseBloquetoService;

    public BoletoImplyResource(AiseDebitoService aiseDebitoService, AiseBloquetoService aiseBloquetoService) {
        this.aiseDebitoService = aiseDebitoService;
        this.aiseBloquetoService = aiseBloquetoService;
    }

    @GetMapping(path={"/debitos"}, params={"tipoCadastro", "cadastroGeral"})
    public ResponseEntity<List<DebitoDTO>> getDebitosAgrupados(CadastroGeralParams params) {
        return ResponseEntity.ok().body((Object)this.aiseDebitoService.getDebitosAgrupados(params));
    }

    @PostMapping
    public ResponseEntity<BloquetoDTO> geraBloquetoPorDataPagamento(@RequestBody GeraBloquetoParams params) {
        BloquetoDTO bloquetoDTO = this.aiseBloquetoService.geraBloquetoPorDataPagamento(params.getDebitos(), params.getDataReferencia(), params.getFormaPagamento());
        return ResponseEntity.ok((Object)bloquetoDTO);
    }
}

