/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaoelogeo;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.dto.integracaoelogeo.TipoSocioElogeoDTO;
import br.com.elotech.tributos.service.TipoSocioService;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/elogeo/tipo-socio"})
public class TipoSocioElogeoResource {
    private final TipoSocioService tipoSocioService;

    public TipoSocioElogeoResource(TipoSocioService tipoSocioService) {
        this.tipoSocioService = tipoSocioService;
    }

    @Operation(summary="Retorna uma lista dos tipos de s\u00f3cios")
    @GetMapping
    public ResponseEntity<List<TipoSocioElogeoDTO>> findAll() {
        List tipoSocios = this.tipoSocioService.findAll().stream().map(TipoSocioElogeoDTO::from).collect(Collectors.toList());
        return ResponseEntity.ok(tipoSocios);
    }

    @Operation(summary="Retorna um tipo s\u00f3cio em espec\u00edfico")
    @GetMapping(value={"/{tipoSocio}"})
    public ResponseEntity<TipoSocioElogeoDTO> findById(@PathVariable Long tipoSocio) {
        TipoSocioElogeoDTO tipoSocioElogeoDTO = this.tipoSocioService.findByTipoSocio(tipoSocio).map(TipoSocioElogeoDTO::from).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o tipo s\u00f3cio '%d'.", tipoSocio)));
        return ResponseEntity.ok((Object)tipoSocioElogeoDTO);
    }
}

