/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaoelogeo;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.dto.integracaoelogeo.TipoLogradouroElogeoDTO;
import br.com.elotech.tributos.service.integracaoelogeo.TipoLogradouroElogeoService;
import io.swagger.v3.oas.annotations.Operation;
import java.io.Serializable;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/elogeo/tipo-logradouro"})
public class TipoLogradouroElogeoResource {
    private final TipoLogradouroElogeoService tipoLogradouroElogeoService;

    public TipoLogradouroElogeoResource(TipoLogradouroElogeoService tipoLogradouroElogeoService) {
        this.tipoLogradouroElogeoService = tipoLogradouroElogeoService;
    }

    @Operation(summary="Retorna uma lista de tipos de logradouro")
    @GetMapping
    public ResponseEntity<Page<TipoLogradouroElogeoDTO>> findAll(@ParameterObject Pageable page) {
        Page tipos = this.tipoLogradouroElogeoService.findAll(page).map(TipoLogradouroElogeoDTO::from);
        return ResponseEntity.ok((Object)tipos);
    }

    @Operation(summary="Retorna um tipo de logradouro em espec\u00edfico")
    @GetMapping(value={"/{id}"})
    public ResponseEntity<TipoLogradouroElogeoDTO> findById(@PathVariable Long id) {
        TipoLogradouroElogeoDTO tipoLogradouroDTO = this.tipoLogradouroElogeoService.findById((Serializable)id).map(TipoLogradouroElogeoDTO::from).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o Tipo Logradouro com o id '%d'.", id)));
        return ResponseEntity.ok((Object)tipoLogradouroDTO);
    }
}

