/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaoelogeo;

import br.com.elotech.tributos.domain.Loteamento;
import br.com.elotech.tributos.dto.integracaoelogeo.LoteamentoElogeoDTO;
import br.com.elotech.tributos.dto.integracaoelogeo.LoteamentoElogeoSearchDTO;
import br.com.elotech.tributos.dto.integracaoelogeo.LoteamentoPostElogeoDTO;
import br.com.elotech.tributos.service.integracaoelogeo.LoteamentoElogeoService;
import io.swagger.v3.oas.annotations.Operation;
import java.net.URI;
import javax.validation.Valid;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/elogeo/loteamento"})
public class LoteamentoElogeoResource {
    private final LoteamentoElogeoService loteamentoElogeoService;

    public LoteamentoElogeoResource(LoteamentoElogeoService loteamentoElogeoService) {
        this.loteamentoElogeoService = loteamentoElogeoService;
    }

    @Operation(summary="Retorna uma lista de loteamentos")
    @GetMapping
    public ResponseEntity<Page<LoteamentoElogeoDTO>> findAll(@ParameterObject Pageable page) {
        return ResponseEntity.ok((Object)this.loteamentoElogeoService.findAllElogeo(page));
    }

    @Operation(summary="Retorna um loteamento em espec\u00edfico")
    @GetMapping(value={"/{id}"})
    public ResponseEntity<LoteamentoElogeoDTO> findByLoteamento(@PathVariable Long id) {
        return ResponseEntity.ok((Object)LoteamentoElogeoDTO.from((Loteamento)this.loteamentoElogeoService.findByLoteamentoElogeoDTO(id)));
    }

    @Operation(summary="Faz uma pesquisa espec\u00edfica pelos campos distrito, setor, codigo, nome")
    @GetMapping(value={"/pesquisa"})
    public ResponseEntity<Page<LoteamentoElogeoDTO>> findByRSQL(@Valid LoteamentoElogeoSearchDTO request, Pageable pageable) {
        return ResponseEntity.ok((Object)this.loteamentoElogeoService.findByRSQL(request.toRsqlSearch(), pageable));
    }

    @Operation(summary="Altera as informa\u00e7\u00f5es de um Loteamento existente")
    @PutMapping(value={"/{loteamento}/distrito/{distrito}/setor/{setor}"})
    public ResponseEntity<LoteamentoElogeoDTO> update(@PathVariable Long loteamento, @PathVariable String distrito, @PathVariable String setor, @RequestBody @Valid LoteamentoPostElogeoDTO loteamentoPostElogeoDTO) {
        return ResponseEntity.ok((Object)this.loteamentoElogeoService.saveElogeoDTO(loteamentoPostElogeoDTO, distrito, setor, loteamento));
    }

    @Operation(summary="Grava um novo Loteamento")
    @PostMapping
    public ResponseEntity<LoteamentoElogeoDTO> save(@RequestBody @Valid LoteamentoPostElogeoDTO loteamentoPostElogeoDTO) {
        return ResponseEntity.created((URI)URI.create("")).body((Object)this.loteamentoElogeoService.saveElogeoDTO(loteamentoPostElogeoDTO));
    }
}

