/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaoelogeo;

import br.com.elotech.tributos.dto.integracaoelogeo.LogradouroTestadaElogeoDTO;
import br.com.elotech.tributos.dto.integracaoelogeo.LogradouroTestadaElogeoSearchRequest;
import br.com.elotech.tributos.dto.integracaoelogeo.LogradouroTestadaPostElogeoDTO;
import br.com.elotech.tributos.service.integracaoelogeo.LogradouroTestadaElogeoService;
import io.swagger.v3.oas.annotations.Operation;
import java.net.URI;
import javax.validation.Valid;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/elogeo/logradouro-testada"})
public class LogradouroTestadaElogeoResource {
    private final LogradouroTestadaElogeoService logradouroTestadaElogeoService;

    public LogradouroTestadaElogeoResource(LogradouroTestadaElogeoService logradouroTestadaElogeoService) {
        this.logradouroTestadaElogeoService = logradouroTestadaElogeoService;
    }

    @Operation(summary="Retorna uma lista de testadas")
    @GetMapping
    public ResponseEntity<Page<LogradouroTestadaElogeoDTO>> findAllDTO(@ParameterObject Pageable page) {
        return ResponseEntity.ok((Object)this.logradouroTestadaElogeoService.findAllElogeoDTO(page));
    }

    @Operation(summary="Retorna uma testada em espec\u00edfico")
    @GetMapping(value={"/{id}"})
    public ResponseEntity<LogradouroTestadaElogeoDTO> findById(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.logradouroTestadaElogeoService.findByIdElogeoDTO(id));
    }

    @Operation(summary="Faz uma pesquisa espec\u00edfica pelos campos logradouro, facequadra e lado")
    @GetMapping(value={"/pesquisa"})
    public ResponseEntity<Page<LogradouroTestadaElogeoDTO>> findByRsql(@Valid LogradouroTestadaElogeoSearchRequest request, Pageable pageable) {
        return ResponseEntity.ok((Object)this.logradouroTestadaElogeoService.findByRsql(request.toRsqlSeach(), pageable));
    }

    @Operation(summary="Altera as informa\u00e7\u00f5es de uma testada existente")
    @PutMapping(value={"/{id}"})
    public ResponseEntity<LogradouroTestadaElogeoDTO> update(@PathVariable Long id, @RequestBody @Valid LogradouroTestadaPostElogeoDTO logradouroTestadaPostElogeoDTO) {
        return ResponseEntity.ok((Object)this.logradouroTestadaElogeoService.saveElogeoDTO(logradouroTestadaPostElogeoDTO, Boolean.FALSE, id));
    }

    @Operation(summary="Grava uma nova testada")
    @PostMapping
    public ResponseEntity<LogradouroTestadaElogeoDTO> save(@RequestBody @Valid LogradouroTestadaPostElogeoDTO logradouroTestadaPostElogeoDTO) {
        return ResponseEntity.created((URI)URI.create("")).body((Object)this.logradouroTestadaElogeoService.saveElogeoDTO(logradouroTestadaPostElogeoDTO, Boolean.TRUE, null));
    }
}

