/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaocontabil;

import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.dto.integracaocontabil.IntegracaoPatrimonialContabilidadeDTO;
import br.com.elotech.tributos.dto.integracaocontabil.LoteIntegracaoContabilDTO;
import br.com.elotech.tributos.dto.integracaocontabil.SolicitacaoIntegracaoDTO;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.TarefaAssincronaService;
import br.com.elotech.tributos.service.integracaocontabil.IntegracaoContabilService;
import br.com.elotech.tributos.service.integracaocontabil.IntegracaoPatrimonialService;
import java.time.LocalDate;
import java.util.List;
import java.util.concurrent.Callable;
import javax.transaction.Transactional;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/integracao-contabil"})
public class IntegracaoContabilResource {
    private final IntegracaoContabilService integracaoContabilService;
    private final IntegracaoPatrimonialService integracaoPatrimonialService;
    private final TarefaAssincronaService tarefaAssincronaService;

    @GetMapping(value={"/lote/{id}"})
    public ResponseEntity<LoteIntegracaoContabilDTO> load(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.integracaoContabilService.loadInformacoesLote(id));
    }

    @PostMapping(value={"/integrar-lote"})
    public ResponseEntity<Void> integrarLote(@RequestBody @Valid SolicitacaoIntegracaoDTO lote) {
        this.integracaoContabilService.integrarLote(lote);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/integrar-datas"})
    public Callable<Void> integrarDatas(@RequestBody List<LocalDate> datasSelecionadas) {
        return () -> {
            UserSecurityDTO userSecurityDTO = SecurityUtils.getUserSecurityDTO();
            this.tarefaAssincronaService.validarTarefaIntegracaoContabilProcessandoComMesmaData(datasSelecionadas);
            this.integracaoContabilService.integrarDatasAssincrono(datasSelecionadas, userSecurityDTO);
            return null;
        };
    }

    @PostMapping(value={"/republish/{id}"})
    @Transactional
    public ResponseEntity<Void> republishIntegracaoFinanceira(@PathVariable(value="id") Long id) {
        this.integracaoContabilService.republish(id);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/patrimonial/{id}"})
    public ResponseEntity<IntegracaoPatrimonialContabilidadeDTO> loadIntegracaoPatrimonial(@PathVariable(value="id") Long id) {
        return this.integracaoPatrimonialService.findByIdDTO(id).map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PostMapping(value={"/patrimonial/republish/{id}"})
    public ResponseEntity<Void> republishIntegracaoPatrimonial(@PathVariable(value="id") Long id) {
        this.integracaoPatrimonialService.republish(id);
        return ResponseEntity.ok().build();
    }

    @Generated
    public IntegracaoContabilResource(IntegracaoContabilService integracaoContabilService, IntegracaoPatrimonialService integracaoPatrimonialService, TarefaAssincronaService tarefaAssincronaService) {
        this.integracaoContabilService = integracaoContabilService;
        this.integracaoPatrimonialService = integracaoPatrimonialService;
        this.tarefaAssincronaService = tarefaAssincronaService;
    }
}

