/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaocontabil;

import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import br.com.elotech.tributos.domain.integracaocontabil.ArrecadacaoPorTipoDetalheDTO;
import br.com.elotech.tributos.domain.integracaocontabil.ArrecadacaoPorTipoFiltroDTO;
import br.com.elotech.tributos.domain.integracaocontabil.ArrecadacaoResumoTodosTiposDTO;
import br.com.elotech.tributos.domain.integracaocontabil.ArrecadacaoResumoValoresTodosTiposDTO;
import br.com.elotech.tributos.service.integracaocontabil.ArrecadacaoService;
import java.util.List;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/arrecadacao"})
public class ArrecadacaoResource {
    private final ArrecadacaoService arrecadacaoService;
    private final BaseExport baseExport;

    public ArrecadacaoResource(ArrecadacaoService arrecadacaoService, BaseExport baseExport) {
        this.arrecadacaoService = arrecadacaoService;
        this.baseExport = baseExport;
    }

    @PostMapping(value={"/arrecadacao-por-tipo/imprimir"})
    public ModelAndView imprimirArrecadacaoPorTipo(@RequestBody @Valid ArrecadacaoPorTipoFiltroDTO filtro, @RequestParam(value="fields") String fields, @RequestParam(value="sumFields") String sumFields, Pageable pageable) {
        List resumoTodosTiposDTOS = this.arrecadacaoService.imprimirResumoArrecadacaoTodosOsTipos(filtro, pageable);
        ReportParam reportParam = ReportParam.builder().clazzDTO(ArrecadacaoResumoTodosTiposDTO.class).fields(fields).sumFields(sumFields).maxRecord(0).page((Page)new PageImpl(resumoTodosTiposDTOS, pageable, (long)resumoTodosTiposDTOS.size())).reportTitle("Consulta Resumo de Arrecada\u00e7\u00e3o por Tipo").searchFilter(filtro.getSearch()).build();
        return this.baseExport.toHTML(reportParam);
    }

    @PostMapping(value={"/arrecadacao-por-tipo"})
    public ResponseEntity<ArrecadacaoResumoValoresTodosTiposDTO> consultaArrecadacaoPorTipo(@RequestBody @Valid ArrecadacaoPorTipoFiltroDTO filtro, Pageable pageable) {
        return ResponseEntity.ok((Object)this.arrecadacaoService.consultaResumoArrecadacaoTodosOsTipos(filtro, pageable));
    }

    @PostMapping(value={"/arrecadacao-por-tipo-detalhe"})
    public ResponseEntity<Page<ArrecadacaoPorTipoDetalheDTO>> consultaArrecadacaoPorTipoDetalhe(@Valid @RequestBody ArrecadacaoPorTipoFiltroDTO filtro, Pageable pageable) {
        return ResponseEntity.ok((Object)this.arrecadacaoService.consultaResumoArrecadacaoPorTipoDetalhe(filtro, pageable));
    }
}

