/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.ecarta;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.tarefaassincrona.TipoTarefaAssincrona;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.dto.ecarta.ExportacaoECartaDTO;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.TarefaAssincronaService;
import br.com.elotech.tributos.service.ecarta.ExportacaoECartaService;
import br.com.elotech.tributos.service.exception.UserNotFoundException;
import java.util.Objects;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/ecarta/exportacao"})
public class ExportacaoECartaResource {
    private final ExportacaoECartaService exportacaoECartaService;
    private final TarefaAssincronaService tarefaAssincronaService;

    @PostMapping(value={"/comunicado"})
    public Callable<Void> exportarComunicadosECartaAssync(@RequestBody ExportacaoECartaDTO exportacaoECartaDTO) {
        return () -> {
            Boolean tarefaEmExecucao = this.tarefaAssincronaService.existsProcessoEmExecucao(TipoTarefaAssincrona.EXPORTACAO_COMUNICADO_ECARTA, "CHAVE_ID_COMUNICADO", exportacaoECartaDTO.getComunicadoId().toString());
            if (Boolean.TRUE.equals(tarefaEmExecucao)) {
                throw new EloValidationException("J\u00e1 existe uma tarefa de exporta\u00e7\u00e3o para o ECarta desse Comunicado em execu\u00e7\u00e3o!");
            }
            UserSecurityDTO userSecurityDTO = SecurityUtils.getUserSecurityDTO();
            if (Objects.isNull(userSecurityDTO.getUserId())) {
                throw new UserNotFoundException("Usu\u00e1rio logado n\u00e3o encontrado.");
            }
            this.exportacaoECartaService.exportarComunicadosECartaTarefa(exportacaoECartaDTO, userSecurityDTO);
            return null;
        };
    }

    @Generated
    public ExportacaoECartaResource(ExportacaoECartaService exportacaoECartaService, TarefaAssincronaService tarefaAssincronaService) {
        this.exportacaoECartaService = exportacaoECartaService;
        this.tarefaAssincronaService = tarefaAssincronaService;
    }
}

