/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.ecarta;

import br.com.elotech.core.resource.support.ReadOnlyResource;
import br.com.elotech.tributos.domain.ComunicadoId;
import br.com.elotech.tributos.domain.ecarta.ComunicadoECarta;
import br.com.elotech.tributos.dto.ecarta.ComunicadoECartaDTO;
import br.com.elotech.tributos.dto.ecarta.ExportacaoECartaResponseDTO;
import br.com.elotech.tributos.service.ecarta.ComunicadoECartaService;
import java.util.List;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/ecarta/comunicado"})
public class ComunicadoECartaResource
extends ReadOnlyResource<ComunicadoECarta, Long> {
    private final ComunicadoECartaService comunicadoECartaService;

    @GetMapping(value={"/search"})
    public ResponseEntity<Page<ComunicadoECartaDTO>> search(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.comunicadoECartaService.findByRsql(search, pageable).map(ComunicadoECartaDTO::from));
    }

    @GetMapping(value={"/{id}/download"})
    public ResponseEntity<ExportacaoECartaResponseDTO> download(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.comunicadoECartaService.getArquivoExportado(id));
    }

    @GetMapping(value={"/comunicadoid/{entidade}/{exercicio}/{idComunicado}"})
    public ResponseEntity<List<ComunicadoECartaDTO>> findByComunicadoId(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long idComunicado) {
        ComunicadoId comunicadoId = ComunicadoId.of((Long)entidade, (Long)exercicio, (Long)idComunicado);
        return ResponseEntity.ok((Object)this.comunicadoECartaService.findByComunicado(comunicadoId));
    }

    @Generated
    public ComunicadoECartaResource(ComunicadoECartaService comunicadoECartaService) {
        this.comunicadoECartaService = comunicadoECartaService;
    }
}

