/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.documento.protesto;

import br.com.elotech.tributos.batch.cenprotms.consultarprotesto.ConsultarProtestoCenprotMSJobStarter;
import br.com.elotech.tributos.batch.cenprotms.gerarprotesto.GerarProtestoCenprotMSJobStarter;
import br.com.elotech.tributos.domain.protesto.Protesto;
import br.com.elotech.tributos.dto.GerarProtestoRemessaDTO;
import br.com.elotech.tributos.dto.ImpressaoDTO;
import br.com.elotech.tributos.dto.LoteBatchInstanceDTO;
import br.com.elotech.tributos.dto.ProtestoDTO;
import br.com.elotech.tributos.dto.cenprot.CenprotMSRetornoDTO;
import br.com.elotech.tributos.dto.cenprot.GerarProtestoCenprotMSDTO;
import br.com.elotech.tributos.dto.documento.GeracaoDocumentoSimplificadoRequest;
import br.com.elotech.tributos.dto.integracaoprotestocra.CraRetornoConsultaTituloDTO;
import br.com.elotech.tributos.enums.cenprot.TipoSistemaProtesto;
import br.com.elotech.tributos.params.FileProtestoParams;
import br.com.elotech.tributos.service.ParametroProtestoService;
import br.com.elotech.tributos.service.ProtestoService;
import br.com.elotech.tributos.service.batch.protesto.GerarProtestoRemessaJobStarter;
import br.com.elotech.tributos.service.cenprotms.CenprotMSService;
import br.com.elotech.tributos.service.documento.DocumentoProtestoService;
import br.com.elotech.tributos.service.integracaoprotestocra.IntegracaoProtestoCraService;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.persistence.EntityNotFoundException;
import javax.validation.Valid;
import javax.xml.bind.JAXBException;
import lombok.Generated;
import org.springframework.batch.core.JobExecution;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/protesto"})
public class ProtestoResource {
    private final ProtestoService protestoService;
    private final DocumentoProtestoService documentoProtestoService;
    private final GerarProtestoRemessaJobStarter gerarProtestoRemessaJobStarter;
    private final IntegracaoProtestoCraService integracaoProtestoCraService;
    private CenprotMSService cenprotMSService;
    private GerarProtestoCenprotMSJobStarter gerarProtestoCenprotMSJobStarter;
    private ParametroProtestoService parametroProtestoService;
    private ConsultarProtestoCenprotMSJobStarter consultarProtestoCenprotMSJobStarter;

    @GetMapping(value={"/lotes-protesto"})
    public ResponseEntity<Page<LoteBatchInstanceDTO>> getTarefas(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.protestoService.getLoteProtestos(Optional.of(search), pageable));
    }

    @GetMapping(value={"/search"})
    public ResponseEntity<Page<ProtestoDTO>> findAllProtestos(@RequestParam Optional<String> search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.protestoService.getProtestos(search, pageable));
    }

    @GetMapping(value={"/lote-protesto/{idLote}"})
    public ResponseEntity<LoteBatchInstanceDTO> findLoteProtestosByIdJob(@PathVariable Long idLote) {
        return ResponseEntity.ok((Object)this.protestoService.findLoteProtestosByIdJob(idLote));
    }

    @GetMapping(value={"/protestos-lote/{idLote}"})
    public ResponseEntity<Page<ProtestoDTO>> findProtestosByLote(@PathVariable Long idLote, Pageable pageable) {
        return ResponseEntity.ok((Object)this.protestoService.findProtestosByLote(idLote, pageable));
    }

    @PostMapping(value={"/gerar-documentos-agrupados"})
    public ResponseEntity<Void> agruparDocumentosProtesto(@RequestBody List<ProtestoDTO> protestos) throws IOException {
        this.documentoProtestoService.agruparDocumentoEnvioCRA(protestos);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/gerar-certidao-protesto"})
    public ResponseEntity<Void> geraCertidaoProtesto(@RequestBody List<Long> protestos) throws IOException {
        this.documentoProtestoService.gerarCertidaoProtesto(protestos);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/gerar-termo-protesto"})
    public ResponseEntity<UUID> gerarTermoProtesto(@Valid @RequestBody FileProtestoParams params) throws IOException {
        return ResponseEntity.ok((Object)this.documentoProtestoService.gerarTermoProtesto(params.getIdProtesto(), params.getDataReferencia()));
    }

    @PostMapping(value={"/gerar-remessa"})
    public ResponseEntity<Void> gerarRemessa(@RequestBody GerarProtestoRemessaDTO gerarProtestoRemessaDTO) {
        this.gerarProtestoRemessaJobStarter.startJob(gerarProtestoRemessaDTO);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/print-protesto-by-id-termo-s3/{idTermoProtestoS3}"})
    public ResponseEntity<String> printDocumentoAgrupadoProtesto(@PathVariable UUID idTermoProtestoS3) {
        return ResponseEntity.ok((Object)this.documentoProtestoService.getUrlAssinada(idTermoProtestoS3));
    }

    @GetMapping(value={"/print-certidao-protesto/{idProtesto}"})
    public ResponseEntity<String> printCertidaoProtesto(@PathVariable Long idProtesto) {
        return ResponseEntity.ok((Object)this.documentoProtestoService.getUrlCertidaoProtesto(idProtesto));
    }

    @GetMapping(value={"/print-protesto/{idProtesto}"})
    public ResponseEntity<String> printDocumentoAgrupadoProtesto(@PathVariable Long idProtesto) {
        return ResponseEntity.ok((Object)this.protestoService.getUrlArquivoAgrupadoProtesto(idProtesto));
    }

    @GetMapping(value={"/{idProtesto}/status-cra"})
    public ResponseEntity<CraRetornoConsultaTituloDTO> consultarProtestoCra(@PathVariable Long idProtesto) throws MalformedURLException, JAXBException, RemoteException {
        Protesto protesto = (Protesto)this.protestoService.findById((Serializable)idProtesto).orElseThrow();
        CraRetornoConsultaTituloDTO craRetornoConsultaTituloDTO = this.integracaoProtestoCraService.consultarRemessa(protesto);
        return ResponseEntity.ok((Object)craRetornoConsultaTituloDTO);
    }

    @PatchMapping(value={"/cancelar/{idProtesto}"})
    public ResponseEntity<Void> cancelarProtesto(@PathVariable(value="idProtesto") Long idProtesto) {
        this.protestoService.cancelarProtesto(idProtesto);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/verifica-debitos-baixados/{idProtesto}"})
    public ResponseEntity<Void> verificaDebitosBaixados(@PathVariable(value="idProtesto") Long idProtesto) {
        this.protestoService.verificaDebitosBaixados(idProtesto);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/imprimir-documento-anuencia"})
    public ResponseEntity<ImpressaoDTO> imprimirDocumentoAnuencia(@RequestBody @Valid GeracaoDocumentoSimplificadoRequest request) {
        return ResponseEntity.ok((Object)this.protestoService.imprimeDocumentoAnuencia(request));
    }

    @PostMapping(value={"/enviar-cenprotms/{idProtesto}"})
    public ResponseEntity<CenprotMSRetornoDTO> enviarProtestoCenprotMS(@PathVariable Long idProtesto) {
        Protesto protesto = (Protesto)this.protestoService.findById((Serializable)idProtesto).orElseThrow(() -> new EntityNotFoundException(String.format("Protesto com id %d n\u00e3o encontrado para envio ao CenprotMS", idProtesto)));
        CenprotMSRetornoDTO retorno = this.cenprotMSService.enviarTitulo(protesto);
        return ResponseEntity.ok((Object)retorno);
    }

    @PostMapping(value={"/enviar-lote-cenprotms"})
    public ResponseEntity<Void> enviarLoteCenprotMS(@RequestBody @Valid GerarProtestoCenprotMSDTO dto) {
        this.gerarProtestoCenprotMSJobStarter.startJob(dto);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/{idProtesto}/status-cenprotms"})
    public ResponseEntity<CenprotMSRetornoDTO> consultarProtestoCenprotMS(@PathVariable Long idProtesto) {
        Protesto protesto = (Protesto)this.protestoService.findById((Serializable)idProtesto).orElseThrow();
        CenprotMSRetornoDTO retorno = this.cenprotMSService.consultarTitulo(protesto);
        return ResponseEntity.ok((Object)retorno);
    }

    @PostMapping(value={"/consultar-lote-status"})
    public ResponseEntity<List<CenprotMSRetornoDTO>> consultarLoteStatus(@RequestBody Map<String, List<Long>> request) {
        List<Long> idsProtesto = request.get("idsProtesto");
        List protestos = this.protestoService.findAllOrThrow(idsProtesto);
        List resultados = this.cenprotMSService.consultarTitulos(protestos);
        return ResponseEntity.ok((Object)resultados);
    }

    @PostMapping(value={"/consultar-lote-status-async"})
    public ResponseEntity<Map<String, Object>> consultarLoteStatusAsync(@RequestBody Map<String, List<Long>> request) {
        List<Long> idsProtesto = request.get("idsProtesto");
        JobExecution jobExecution = this.consultarProtestoCenprotMSJobStarter.startConsultaJob(idsProtesto);
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("jobId", jobExecution.getId());
        response.put("status", jobExecution.getStatus().toString());
        response.put("message", "Consulta iniciada em background. Voc\u00ea ser\u00e1 notificado quando conclu\u00edda.");
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/sistema-ativo"})
    public ResponseEntity<TipoSistemaProtesto> getSistemaProtestoAtivo() {
        return ResponseEntity.ok((Object)this.parametroProtestoService.getSistemaProtestoAtivo());
    }

    @GetMapping(value={"/cenprotms-disponivel"})
    public ResponseEntity<Boolean> isCenprotMSDisponivel() {
        return ResponseEntity.ok((Object)this.cenprotMSService.isCenprotMSDisponivel());
    }

    @Generated
    public ProtestoResource(ProtestoService protestoService, DocumentoProtestoService documentoProtestoService, GerarProtestoRemessaJobStarter gerarProtestoRemessaJobStarter, IntegracaoProtestoCraService integracaoProtestoCraService, CenprotMSService cenprotMSService, GerarProtestoCenprotMSJobStarter gerarProtestoCenprotMSJobStarter, ParametroProtestoService parametroProtestoService, ConsultarProtestoCenprotMSJobStarter consultarProtestoCenprotMSJobStarter) {
        this.protestoService = protestoService;
        this.documentoProtestoService = documentoProtestoService;
        this.gerarProtestoRemessaJobStarter = gerarProtestoRemessaJobStarter;
        this.integracaoProtestoCraService = integracaoProtestoCraService;
        this.cenprotMSService = cenprotMSService;
        this.gerarProtestoCenprotMSJobStarter = gerarProtestoCenprotMSJobStarter;
        this.parametroProtestoService = parametroProtestoService;
        this.consultarProtestoCenprotMSJobStarter = consultarProtestoCenprotMSJobStarter;
    }
}

