/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.documento;

import br.com.elotech.tributos.dto.DocumentoDTO;
import br.com.elotech.tributos.dto.DocumentoGenericoDTO;
import br.com.elotech.tributos.dto.DocumentoSearchInitialValuesDTO;
import br.com.elotech.tributos.dto.ImpressaoDTO;
import br.com.elotech.tributos.service.DocumentoService;
import br.com.elotech.tributos.service.documento.CertidaoInscricaoService;
import java.io.IOException;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/certidao-inscricao"})
@RestController
public class CertidaoInscricaoResource {
    private final CertidaoInscricaoService certidaoInscricaoService;
    private final DocumentoService documentoService;

    @PostMapping(value={"/valores-iniciais"})
    public ResponseEntity<DocumentoGenericoDTO> getInitialValues(@RequestBody DocumentoSearchInitialValuesDTO documentoSearchInitialValuesDTO) {
        return ResponseEntity.ok((Object)this.certidaoInscricaoService.getInitialValues(documentoSearchInitialValuesDTO));
    }

    @PostMapping
    public ResponseEntity<ImpressaoDTO> buildCertidaoEncerramento(@RequestBody @Valid DocumentoGenericoDTO geracaoDocumentoDto) throws IOException {
        DocumentoDTO dto = this.certidaoInscricaoService.save(geracaoDocumentoDto);
        return ResponseEntity.ok((Object)this.documentoService.imprimirDocumento(dto.getId(), geracaoDocumentoDto.getRelatorioImpressao(), Boolean.FALSE));
    }

    @PutMapping(value={"/{id}/editar"})
    public ResponseEntity<ImpressaoDTO> editar(@PathVariable(value="id") Long id, @RequestBody @Valid DocumentoGenericoDTO documentoGenericoDTO) throws IOException {
        DocumentoDTO documentoDTO = this.certidaoInscricaoService.editar(id, documentoGenericoDTO);
        return ResponseEntity.ok((Object)this.documentoService.imprimirDocumento(documentoDTO.getId(), documentoGenericoDTO.getRelatorioImpressao(), Boolean.TRUE));
    }

    @Generated
    public CertidaoInscricaoResource(CertidaoInscricaoService certidaoInscricaoService, DocumentoService documentoService) {
        this.certidaoInscricaoService = certidaoInscricaoService;
        this.documentoService = documentoService;
    }
}

