/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.cancelamento;

import br.com.elotech.tributos.domain.cancelamento.CancelamentoDebitoPk;
import br.com.elotech.tributos.dto.CancelamentoDebitoDTO;
import br.com.elotech.tributos.dto.CancelamentoDebitoParcelaDTO;
import br.com.elotech.tributos.dto.CancelamentoDebitoTributoDTO;
import br.com.elotech.tributos.service.cancelamento.EstornoCancelamentoDebitoService;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/estorno-cancelamentos-debito"})
public class EstornoCancelamentoDebitoResource {
    private final EstornoCancelamentoDebitoService estornoCancelamentoDebitoService;

    public EstornoCancelamentoDebitoResource(EstornoCancelamentoDebitoService estornoCancelamentoDebitoService) {
        this.estornoCancelamentoDebitoService = estornoCancelamentoDebitoService;
    }

    @PostMapping(value={"/por-tributo/{entidade}/{exercicio}/{idCancelamento}"})
    public ResponseEntity<CancelamentoDebitoDTO> estornarPorTributo(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long idCancelamento, @RequestBody List<CancelamentoDebitoTributoDTO> tributos) {
        return ResponseEntity.ok((Object)this.estornoCancelamentoDebitoService.estornarPorTributo(new CancelamentoDebitoPk(entidade, exercicio, idCancelamento), tributos));
    }

    @PostMapping(value={"/por-parcela/{entidade}/{exercicio}/{idCancelamento}"})
    public ResponseEntity<CancelamentoDebitoDTO> estornarPorParcela(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long idCancelamento, @RequestBody List<CancelamentoDebitoParcelaDTO> parcelas) {
        return ResponseEntity.ok((Object)this.estornoCancelamentoDebitoService.estornarPorParcela(new CancelamentoDebitoPk(entidade, exercicio, idCancelamento), parcelas));
    }
}

