/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.cancelamento;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.resource.support.ReadOnlyResource;
import br.com.elotech.tributos.domain.cancelamento.CancelamentoDebito;
import br.com.elotech.tributos.domain.cancelamento.CancelamentoDebitoPk;
import br.com.elotech.tributos.domain.tarefaassincrona.TipoTarefaAssincrona;
import br.com.elotech.tributos.dto.CancelamentoDebitoDTO;
import br.com.elotech.tributos.dto.CancelamentoDebitoTributoDTO;
import br.com.elotech.tributos.dto.TributoDTO;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.dto.cancelamento.CancelamentoParcelasFormDTO;
import br.com.elotech.tributos.dto.cancelamento.CancelamentoTributosFormDTO;
import br.com.elotech.tributos.params.DebitoFilterParams;
import br.com.elotech.tributos.params.DebitoTributosPorcentagemParams;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.DebitoParcelaTributoService;
import br.com.elotech.tributos.service.TarefaAssincronaService;
import br.com.elotech.tributos.service.cancelamento.CancelamentoDebitoService;
import br.com.elotech.tributos.service.exception.UserNotFoundException;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cancelamentos-debito"})
public class CancelamentoDebitoResource
extends ReadOnlyResource<CancelamentoDebito, CancelamentoDebitoPk> {
    private final CancelamentoDebitoService cancelamentoDebitoService;
    private final DebitoParcelaTributoService debitoParcelasTributoService;
    private final TarefaAssincronaService tarefaAssincronaService;

    public CancelamentoDebitoResource(CancelamentoDebitoService cancelamentoDebitoService, DebitoParcelaTributoService debitoParcelasTributoService, TarefaAssincronaService tarefaAssincronaService) {
        this.cancelamentoDebitoService = cancelamentoDebitoService;
        this.debitoParcelasTributoService = debitoParcelasTributoService;
        this.tarefaAssincronaService = tarefaAssincronaService;
    }

    @GetMapping(value={"/pk/{entidade}/{exercicio}/{id}"})
    public ResponseEntity<CancelamentoDebitoDTO> findOne(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long id) {
        CancelamentoDebito cancelamentoDebito = (CancelamentoDebito)this.cancelamentoDebitoService.findOne((Serializable)new CancelamentoDebitoPk(entidade, exercicio, id));
        return ResponseEntity.ok((Object)CancelamentoDebitoDTO.from((CancelamentoDebito)cancelamentoDebito));
    }

    @PostMapping(value={"/por-parcela"})
    public ResponseEntity<CancelamentoDebito> cancelamentoDebitoPorParcela(@RequestBody @Valid CancelamentoParcelasFormDTO cancelamento) {
        return ResponseEntity.ok((Object)this.cancelamentoDebitoService.cancelamentoDebitoPorParcela(cancelamento));
    }

    @PostMapping(value={"/por-tributo"})
    public ResponseEntity<CancelamentoDebito> cancelamentoDebitoPorTributo(@RequestBody @Valid CancelamentoTributosFormDTO cancelamento) {
        return ResponseEntity.ok((Object)this.cancelamentoDebitoService.cancelamentoDebitoPorTributo(cancelamento));
    }

    @PostMapping(value={"/por-tributo/async"})
    public Callable<Void> cancelamentoDebitoPorTributoAsync(@RequestBody @Valid CancelamentoTributosFormDTO cancelamento) {
        return () -> {
            boolean existeTarefaEmExecucao = this.tarefaAssincronaService.existsProcessoEmExecucao(TipoTarefaAssincrona.CANCELAMENTO_DEBITO, "CHAVE_CANCELAMENTO_DEBITO", String.format("%s/%s/%s", cancelamento.getEntidade(), cancelamento.getExercicio(), cancelamento.getDataCancelamento()));
            if (existeTarefaEmExecucao) {
                throw new EloValidationException("J\u00e1 existe um cancelamento de d\u00e9bito em execu\u00e7\u00e3o para o(s) tributo(s) selecionado(s).");
            }
            UserSecurityDTO userSecurityDTO = SecurityUtils.getUserSecurityDTO();
            if (Objects.isNull(userSecurityDTO.getUserId())) {
                throw new UserNotFoundException("Usu\u00e1rio logado n\u00e3o encontrado.");
            }
            this.cancelamentoDebitoService.cancelamentoDebitoPorTributoAsync(cancelamento, userSecurityDTO);
            return null;
        };
    }

    @PostMapping(value={"/por-parcela/parcelas"})
    public ResponseEntity<List<CancelamentoDebitoTributoDTO>> findByDebitoAndAberto(@RequestBody DebitoFilterParams debito) {
        return ResponseEntity.ok((Object)this.debitoParcelasTributoService.findByDebitoAndAberto(debito));
    }

    @PostMapping(value={"/por-tributo/tributos"})
    public ResponseEntity<List<TributoDTO>> getDebitoTributoDescricao(@RequestBody DebitoFilterParams params) {
        return ResponseEntity.ok((Object)this.debitoParcelasTributoService.getDebitoTributoDescricao(params));
    }

    @PostMapping(value={"/por-tributo/parcelas"})
    public ResponseEntity<List<CancelamentoDebitoTributoDTO>> getDebitoParcelaTributoCancelamento(@RequestBody @Valid DebitoTributosPorcentagemParams params) {
        return ResponseEntity.ok((Object)this.debitoParcelasTributoService.getDebitoParcelaTributoCancelamento(params));
    }
}

