/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.camposdinamicos;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.camposdinamicos.FuncionalidadeCampo;
import br.com.elotech.tributos.domain.camposdinamicos.GrupoCampo;
import br.com.elotech.tributos.dto.camposdinamicos.CampoValidacaoDTO;
import br.com.elotech.tributos.dto.camposdinamicos.GrupoRespostasDTO;
import br.com.elotech.tributos.service.camposdinamicos.GrupoCampoService;
import br.com.elotech.tributos.service.camposdinamicos.RespostaService;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/grupo-campo"})
public class GrupoCampoResource
extends CrudResource<GrupoCampo, Long> {
    private final GrupoCampoService grupoCampoService;
    private final RespostaService respostaService;

    public GrupoCampoResource(GrupoCampoService grupoCampoService, RespostaService respostaService) {
        this.grupoCampoService = grupoCampoService;
        this.respostaService = respostaService;
    }

    @GetMapping(value={"/respostas-agrupadas"})
    public ResponseEntity<List<GrupoRespostasDTO>> getRespostasAgrupadas(@RequestParam(value="funcionalidade") FuncionalidadeCampo funcionalidadeCampo) {
        return ResponseEntity.ok((Object)this.respostaService.getRespostasAgrupadasVazias(funcionalidadeCampo));
    }

    @GetMapping(value={"/campos-validacao"})
    public ResponseEntity<List<CampoValidacaoDTO>> getCamposParaValidacao(@RequestParam(value="funcionalidade") FuncionalidadeCampo funcionalidadeCampo) {
        return ResponseEntity.ok((Object)this.grupoCampoService.getCamposParaValidacao(funcionalidadeCampo));
    }
}

