/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.acrescimo;

import br.com.elotech.tributos.dto.acrescimo.AcrescimoDTO;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.acrescimo.SimulacaoAcrescimoService;
import java.util.List;
import javax.validation.Valid;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/simulacao-acrescimo"})
public class SimulacaoAcrescimoResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SimulacaoAcrescimoResource.class);
    private final SimulacaoAcrescimoService simulacaoAcrescimoService;

    public SimulacaoAcrescimoResource(SimulacaoAcrescimoService simulacaoAcrescimoService) {
        this.simulacaoAcrescimoService = simulacaoAcrescimoService;
    }

    @PostMapping
    public ResponseEntity<AcrescimoDTO> simularAcrescimo(@RequestBody @Valid AcrescimoDTO params) {
        log.debug("IP de origem da requisicao: {}", (Object)SecurityUtils.getRequestIP());
        return ResponseEntity.ok((Object)this.simulacaoAcrescimoService.simular(params));
    }

    @PostMapping(value={"/lote"})
    public ResponseEntity<List<AcrescimoDTO>> simularAcrescimoLote(@RequestBody @Valid List<AcrescimoDTO> params) {
        log.debug("{} registros recebidos", (Object)params.size());
        log.debug("IP de origem da requisicao: {}", (Object)SecurityUtils.getRequestIP());
        return ResponseEntity.ok((Object)this.simulacaoAcrescimoService.simular(params));
    }
}

