/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.webiss.WebIssArquivo;
import br.com.elotech.tributos.dto.webiss.LogRegistroWebIssDTO;
import br.com.elotech.tributos.dto.webiss.Registro312DTO;
import br.com.elotech.tributos.dto.webiss.Registro334DTO;
import br.com.elotech.tributos.dto.webiss.WebIssArquivoDTO;
import br.com.elotech.tributos.enums.webiss.TipoRegistroWebIss;
import br.com.elotech.tributos.service.webiss.ImportacaoArquivoWebIssService;
import br.com.elotech.tributos.service.webiss.WebIssArquivoService;
import br.com.elotech.tributos.service.webiss.WebIssLogRegistroService;
import br.com.elotech.tributos.service.webiss.WebIssRegistro312Service;
import br.com.elotech.tributos.service.webiss.WebIssRegistro334Service;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/webiss"})
public class WebIssResource
extends CrudResource<WebIssArquivo, Long> {
    private final ImportacaoArquivoWebIssService importacaoArquivoWebIssService;
    private final WebIssArquivoService webIssArquivoService;
    private final WebIssRegistro334Service webIssRegistro334Service;
    private final WebIssRegistro312Service webIssRegistro312Service;
    private final WebIssLogRegistroService webIssLogRegistroService;

    @GetMapping(value={"/importar-arquivo"})
    public ResponseEntity<Void> importarArquivoWebIss(@RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate dataInicio, @RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate dataFinal) {
        this.importacaoArquivoWebIssService.downloadArquivoPagamentoWebIss(dataInicio, dataFinal);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/reprocessar-arquivo/{tipoArquivo}/{id}/{numLinha}"})
    public ResponseEntity<Void> reprocessarArquivoByNumLinha(@PathVariable Long tipoArquivo, @PathVariable Long id, @PathVariable Long numLinha) {
        this.importacaoArquivoWebIssService.reprocessarLinha(TipoRegistroWebIss.fromValue((String)tipoArquivo.toString()), id, numLinha);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/reprocessar-arquivo/{tipoArquivo}/{id}"})
    public ResponseEntity<Void> reprocessarArquivo(@PathVariable Long tipoArquivo, @PathVariable Long id) {
        this.importacaoArquivoWebIssService.reprocessarArquivo(TipoRegistroWebIss.fromValue((String)tipoArquivo.toString()), id);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/search"})
    public ResponseEntity<Page<WebIssArquivoDTO>> findAllArquivos(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.webIssArquivoService.findAllArquivos(search, pageable));
    }

    @GetMapping(value={"/registro334/search"})
    public ResponseEntity<Page<Registro334DTO>> findAllRegistros334ByIdArquivo(@RequestParam(value="search") String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.webIssRegistro334Service.findAllArquivos(search, pageable));
    }

    @GetMapping(value={"/registro312/search"})
    public ResponseEntity<Page<Registro312DTO>> findAllRegistros312ByIdArquivo(@RequestParam(value="search") String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.webIssRegistro312Service.findAllArquivos(search, pageable));
    }

    @GetMapping(value={"/importar-arquivo-debitos-bloqueados"})
    public ResponseEntity<Void> importarArquivoWebIss(@RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate dataBloqueio) {
        this.importacaoArquivoWebIssService.downloadArquivoDebitosBloqueadosWebIss(dataBloqueio);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/search-inconsistencia/{id}/{numLinha}"})
    public ResponseEntity<List<LogRegistroWebIssDTO>> findInconsistenciaByIdArquivoAndNumLinha(@PathVariable Long id, @PathVariable Long numLinha) {
        return ResponseEntity.ok((Object)this.webIssLogRegistroService.findByIdArquivoAndNumLinha(id, numLinha));
    }

    @Generated
    public WebIssResource(ImportacaoArquivoWebIssService importacaoArquivoWebIssService, WebIssArquivoService webIssArquivoService, WebIssRegistro334Service webIssRegistro334Service, WebIssRegistro312Service webIssRegistro312Service, WebIssLogRegistroService webIssLogRegistroService) {
        this.importacaoArquivoWebIssService = importacaoArquivoWebIssService;
        this.webIssArquivoService = webIssArquivoService;
        this.webIssRegistro334Service = webIssRegistro334Service;
        this.webIssRegistro312Service = webIssRegistro312Service;
        this.webIssLogRegistroService = webIssLogRegistroService;
    }
}

