/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.dto.TipoCadastroAbaDTO;
import br.com.elotech.tributos.service.TipoCadastroAbaService;
import java.util.List;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tipos-cadastro-aba"})
public class TipoCadastroAbaResource {
    private final TipoCadastroAbaService service;

    @GetMapping(value={"/search"})
    public ResponseEntity<Page<TipoCadastroAbaDTO>> search(@RequestParam(required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.service.search(search, pageable));
    }

    @GetMapping(value={"{id}"})
    public ResponseEntity<TipoCadastroAbaDTO> findDtoById(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.service.findDtoById(id));
    }

    @GetMapping(value={"/tipo-cadastro/{tipoCadastro}/visiveis"})
    public ResponseEntity<List<TipoCadastroAbaDTO>> getVisiveisByTipoCadastro(@PathVariable Long tipoCadastro) {
        return ResponseEntity.ok((Object)this.service.getVisiveisByTipoCadastro(tipoCadastro));
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Void> updateAba(@PathVariable Long id, @RequestBody TipoCadastroAbaDTO dto) {
        this.service.updateAba(id, dto);
        return ResponseEntity.ok().build();
    }

    @Generated
    public TipoCadastroAbaResource(TipoCadastroAbaService service) {
        this.service = service;
    }
}

