/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincrona;
import br.com.elotech.tributos.domain.tarefaassincrona.TipoTarefaAssincrona;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.dto.tarefaassincrona.TarefaAssincronaDTO;
import br.com.elotech.tributos.dto.tarefaassincrona.TarefaAssincronaExecucaoDTO;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.TarefaAssincronaService;
import br.com.elotech.tributos.service.integracaocontabil.IntegracaoContabilService;
import br.com.elotech.tributos.service.rol.RolService;
import java.util.List;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tarefa-assincrona"})
public class TarefaAssincronaResource {
    private final TarefaAssincronaService tarefaAssincronaService;
    private final IntegracaoContabilService integracaoContabilService;
    private final RolService rolService;

    @GetMapping
    public ResponseEntity<Page<TarefaAssincronaDTO>> searchTarefas(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.tarefaAssincronaService.searchTarefas(search, pageable));
    }

    @GetMapping(value={"/{tarefa}/historico"})
    public ResponseEntity<List<TarefaAssincronaExecucaoDTO>> findHistoricoExecucoesByTarefa(@PathVariable Long tarefa) {
        return ResponseEntity.ok((Object)this.tarefaAssincronaService.findHistoricoExecucoesByTarefa(tarefa));
    }

    @PostMapping(value={"/{tarefa}/retry"})
    public Callable<Void> retryTarefa(@PathVariable Long tarefa) {
        return () -> {
            TarefaAssincrona tarefaAssincrona = this.tarefaAssincronaService.findOne(tarefa);
            if (TipoTarefaAssincrona.INTEGRACAO_CONTABIL_DIA.equals((Object)tarefaAssincrona.getTipo())) {
                UserSecurityDTO userSecurityDTO = SecurityUtils.getUserSecurityDTO();
                this.integracaoContabilService.retryIntegrarDatasAssincrono(tarefa, userSecurityDTO);
            } else if (TipoTarefaAssincrona.GERACAO_ROL.equals((Object)tarefaAssincrona.getTipo())) {
                this.rolService.reiniciarRolAsync(tarefaAssincrona.getLastExecucaoId(), SecurityUtils.getUserSecurityDTO());
            } else {
                throw new EloValidationException(String.format("N\u00e3o foi implementada a retomada para tarefas do tipo %s.", tarefaAssincrona.getTipo().getDescricao()));
            }
            return null;
        };
    }

    @Generated
    public TarefaAssincronaResource(TarefaAssincronaService tarefaAssincronaService, IntegracaoContabilService integracaoContabilService, RolService rolService) {
        this.tarefaAssincronaService = tarefaAssincronaService;
        this.integracaoContabilService = integracaoContabilService;
        this.rolService = rolService;
    }
}

