/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import br.com.elotech.tributos.calculo.dto.ReajusteValorSimulacaoDTO;
import br.com.elotech.tributos.calculo.repository.ReajusteValorItemRepository;
import br.com.elotech.tributos.calculo.service.ReajusteValorService;
import br.com.elotech.tributos.domain.calculo.ReajusteValor;
import br.com.elotech.tributos.domain.calculo.ReajusteValorItemReport;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/reajuste-valor"})
public class ReajuseValorResource
extends CrudResource<ReajusteValor, Long> {
    private static final String TIPO_IMPRESSAO_SIMULACAO = "simulacao";
    private final ReajusteValorService reajusteValorService;
    private final ReajusteValorItemRepository reajusteValorItemRepository;
    private final BaseExport baseExport;

    @PostMapping(value={"/simular"})
    public ResponseEntity<ReajusteValor> simular(@RequestBody ReajusteValorSimulacaoDTO simulacaoDTO) {
        return ResponseEntity.ok((Object)this.reajusteValorService.simular(simulacaoDTO));
    }

    @PostMapping(value={"/apagar-simulacao/{id}"})
    public ResponseEntity<Void> apagarSimulacao(@PathVariable Long id) {
        this.reajusteValorService.apagarSimulacao(id);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/efetivar"})
    public ResponseEntity<ReajusteValor> efetivar(@RequestBody ReajusteValor reajusteValor) {
        return ResponseEntity.ok((Object)this.reajusteValorService.efetivar(reajusteValor));
    }

    @PostMapping(value={"/estornar/{id}"})
    public ResponseEntity<ReajusteValor> estornar(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.reajusteValorService.estornar(id));
    }

    @GetMapping(value={"/imprimir"})
    public ModelAndView imprimir(@RequestParam(value="id") Long id, @RequestParam(value="tipoImpressao") String tipoImpressao, Pageable pageable) {
        Pageable page = Optional.ofNullable(pageable).orElseGet(Pageable::unpaged);
        List<ReajusteValorItemReport> itens = this.reajusteValorItemRepository.findByReajusteValorId(id, page).stream().map(ReajusteValorItemReport::of).toList();
        String title = String.format("Relat\u00f3rio de Reajuste de Valores%s", TIPO_IMPRESSAO_SIMULACAO.equals(tipoImpressao) ? " (Simula\u00e7\u00e3o)" : "");
        ReportParam reportParam = ReportParam.builder().clazzDTO(ReajusteValorItemReport.class).fields("tipo,descricao,valor,valorAtualizado,valorItbi,valorItbiAtualizado").maxRecord(0).page((Page)new PageImpl(itens, page, (long)itens.size())).reportTitle(title).build();
        return this.baseExport.toHTML(reportParam);
    }

    @Generated
    public ReajuseValorResource(ReajusteValorService reajusteValorService, ReajusteValorItemRepository reajusteValorItemRepository, BaseExport baseExport) {
        this.reajusteValorService = reajusteValorService;
        this.reajusteValorItemRepository = reajusteValorItemRepository;
        this.baseExport = baseExport;
    }
}

