/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.Profissional;
import br.com.elotech.tributos.domain.ProfissionalId;
import br.com.elotech.tributos.dto.ProfissionalDTO;
import br.com.elotech.tributos.service.ProfissionalService;
import java.io.Serializable;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/profissional"})
public class ProfissionalResource
extends CrudResource<Profissional, ProfissionalId> {
    private final ProfissionalService profissionalService;

    @GetMapping(value={"/dto"})
    public ResponseEntity<Page<ProfissionalDTO>> findAllWithDistinct(String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.profissionalService.findAllWithDistinct(search, pageable));
    }

    @GetMapping(value={"/custom/{id}"})
    public ResponseEntity<Profissional> findById(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.profissionalService.findByIdPessoaId(id));
    }

    @PutMapping(value={"/custom/{id}"})
    public ResponseEntity<Profissional> update(@RequestBody @Valid Profissional profissional, @PathVariable(value="id") Long id, Authentication authentication) {
        ProfissionalId profissionalId = this.profissionalService.findByIdPessoaId(id).getId();
        return ResponseEntity.ok((Object)((Profissional)super.update((EloEntity)profissional, (Serializable)profissionalId, authentication).getBody()));
    }

    @Generated
    public ProfissionalResource(ProfissionalService profissionalService) {
        this.profissionalService = profissionalService;
    }
}

