/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.domain.DividaUsuario;
import br.com.elotech.tributos.dto.DividaUsuarioDTO;
import br.com.elotech.tributos.dto.PermissaoDividaUsuarioDTO;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.PermissoesDividaService;
import java.util.List;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/permissoes-divida"})
public class PermissoesDividaResource {
    private final PermissoesDividaService permissoesDividaService;

    public PermissoesDividaResource(PermissoesDividaService permissoesDividaService) {
        this.permissoesDividaService = permissoesDividaService;
    }

    @GetMapping(value={"/{usuario}"})
    public ResponseEntity<List<DividaUsuarioDTO>> getPermissoesDividaByUsuario(@PathVariable String usuario) {
        return ResponseEntity.ok((Object)this.permissoesDividaService.getPermissoesDividaByUsuario(usuario));
    }

    @PostMapping(value={"/save"})
    public ResponseEntity<DividaUsuario> save(@RequestBody @Valid DividaUsuarioDTO dividaUsuarioDTO) {
        return ResponseEntity.ok((Object)this.permissoesDividaService.save(dividaUsuarioDTO));
    }

    @PostMapping(value={"/copy/{usuarioASerCopiado}/{usuarioAReceber}"})
    public ResponseEntity<PermissaoDividaUsuarioDTO> copiarPermissoes(@PathVariable String usuarioASerCopiado, @PathVariable String usuarioAReceber) {
        return ResponseEntity.ok((Object)this.permissoesDividaService.copiarPermissoes(usuarioASerCopiado, usuarioAReceber));
    }

    @GetMapping(value={"/valida-permissao/{entidade}/{exercicio}/{divida}"})
    public ResponseEntity<Void> validaPermissaoDividaByUsuario(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long divida) {
        this.permissoesDividaService.possuiPermissaoDividaByUsuario(entidade, exercicio, divida, SecurityUtils.getUserAise());
        return ResponseEntity.ok().build();
    }
}

