/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.core.utils.web.ResponseUtils;
import br.com.elotech.tributos.domain.ParametroGeral;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.ParcelamentoCarne;
import br.com.elotech.tributos.domain.parcelamento.Parcelamento;
import br.com.elotech.tributos.domain.parcelamento.SituacaoParcelamentoEnum;
import br.com.elotech.tributos.domain.tarefaassincrona.TipoTarefaAssincrona;
import br.com.elotech.tributos.dto.BloquetoDTO;
import br.com.elotech.tributos.dto.ImpressaoCarneParcelamentoDTO;
import br.com.elotech.tributos.dto.ImprimirRelatorioDTO;
import br.com.elotech.tributos.dto.ParcelamentoListItem;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.dto.filtros.FiltroMultiValueParcelamento;
import br.com.elotech.tributos.dto.parcelamento.AiseDebitoParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.BuscarNumeroParcelasImpressaoBoletoDTO;
import br.com.elotech.tributos.dto.parcelamento.EstornoParcelamentoEmLoteDTO;
import br.com.elotech.tributos.dto.parcelamento.EstornoParcelamentoRowDTO;
import br.com.elotech.tributos.dto.parcelamento.FiltroEstornoParcelamentoEmLoteDTO;
import br.com.elotech.tributos.dto.parcelamento.ImpressaoBoletoParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.NumeroParcelasImpressaoBoletoDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoDebitoDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoDebitoParcelasDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoPassivelQuitacaoDTO;
import br.com.elotech.tributos.dto.parcelamento.RequestSimularQuitarContratoDTO;
import br.com.elotech.tributos.dto.parcelamento.ResumoParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.SimulacaoParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.SimulacaoParcelamentoRequestDTO;
import br.com.elotech.tributos.dto.parcelamento.SimularQuitarContratoDTO;
import br.com.elotech.tributos.resource.RelatorioResource;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.HistoricoAtendimentoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.ParcelamentoCarneService;
import br.com.elotech.tributos.service.ParcelamentoService;
import br.com.elotech.tributos.service.TarefaAssincronaService;
import br.com.elotech.tributos.service.exception.UserNotFoundException;
import br.com.elotech.tributos.service.ws.AiseParcelamentoService;
import br.com.elotech.tributos.ws.rest.dto.ParamDebitosPassiveisParcelamentoDTO;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/parcelamentos"})
public class ParcelamentoResource
extends CrudResource<Parcelamento, Long> {
    private static final String ARQUIVO_IMPRESSAO_BOLETO = "BoletoParcelamento.pdf";
    private static final String ARQUIVO_SIMULACAO_QUITACAO = "SimulacaoQuitacao.pdf";
    private static final String ARQUIVO_CONTRATO_PARCELAMENTO = "ContratoParcelamento.pdf";
    private static final Integer PARCELA_UNICA = 1;
    private final ParcelamentoService parcelamentoService;
    private final ParcelamentoCarneService parcelamentoCarneService;
    private final AiseParcelamentoService aiseParcelamentoService;
    private final RelatorioResource relatorioResource;
    private final ParametroGeralService parametroGeralService;
    private final TarefaAssincronaService tarefaAssincronaService;
    private final HistoricoAtendimentoService historicoAtendimentoService;

    @GetMapping(value={"/{idParcelamento}/novo"})
    public ResponseEntity<List<ParcelamentoDebitoDTO>> findParcelamentoDebitoNovo(@PathVariable Long idParcelamento) {
        return ResponseEntity.ok((Object)this.parcelamentoService.findParcelamentoDebitoNovo(idParcelamento));
    }

    @GetMapping(value={"/{idParcelamento}/origem"})
    public ResponseEntity<List<ParcelamentoDebitoDTO>> findParcelamentoDebitoOrigem(@PathVariable Long idParcelamento) {
        return ResponseEntity.ok((Object)this.parcelamentoService.findParcelamentoDebitoOrigem(idParcelamento));
    }

    @GetMapping(value={"/debitos-passiveis-parcelamento"}, params={"tipoCadastro", "cadastroGeral", "dataCorrecao", "idParametroParcelamento"})
    public ResponseEntity<List<AiseDebitoParcelamentoDTO>> findDebitosPassiveisParcelamento(ParamDebitosPassiveisParcelamentoDTO param) {
        return ResponseEntity.ok((Object)this.aiseParcelamentoService.findDebitosPassiveisParcelamento(param));
    }

    @PostMapping(value={"/simular-cidadao"})
    public ResponseEntity<SimulacaoParcelamentoDTO> simularParcelamentoCidadao(@RequestBody SimulacaoParcelamentoRequestDTO simulacaoParcelamentoRequestDTO) {
        return ResponseEntity.ok((Object)this.aiseParcelamentoService.getSimulacoesCidadao(simulacaoParcelamentoRequestDTO));
    }

    @PostMapping(value={"/simular"})
    public ResponseEntity<SimulacaoParcelamentoDTO> simularParcelamento(@Valid @RequestBody SimulacaoParcelamentoDTO param) {
        return ResponseEntity.ok((Object)this.aiseParcelamentoService.simularParcelamento(param));
    }

    @PostMapping(value={"/imprimir-simulacao-refis"})
    public void imprimirSimulacaoRefis(@RequestBody SimulacaoParcelamentoDTO simulacao, HttpServletResponse response) throws IOException {
        byte[] arquivo = this.parcelamentoService.imprimirSimulacaoRefis(simulacao);
        if (arquivo == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "N\u00e3o foi poss\u00edvel gerar a simula\u00e7\u00e3o de parcelamento de d\u00e9bito(s).");
        }
        ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])arquivo, (String)"simulacao-refis.pdf");
    }

    @PostMapping(value={"/gerar"})
    public ResponseEntity<ResumoParcelamentoDTO> gerarParcelamento(@Valid @RequestBody SimulacaoParcelamentoDTO param) throws JsonProcessingException {
        param.setHeaderAtendimento(this.historicoAtendimentoService.getHeaderAtendimento());
        return ResponseEntity.ok((Object)this.aiseParcelamentoService.gerarParcelamento(param, SecurityUtils.getUserSecurityDTO()));
    }

    @GetMapping(value={"/{idParcelamento}/parcelas"})
    public ResponseEntity<List<ParcelamentoDebitoParcelasDTO>> findParcelamentoDebitoParcelas(@PathVariable Long idParcelamento) {
        return ResponseEntity.ok((Object)this.parcelamentoService.findParcelamentoDebitoParcelas(idParcelamento));
    }

    @PostMapping(value={"/parcelas"})
    public ResponseEntity<List<ParcelamentoDebitoParcelasDTO>> findParcelas(@RequestBody List<Long> idParcelamentos) {
        ParametroGeral parametroGeracaoCarneparcelamentoOxy = this.parametroGeralService.findByParametroAndModulo(ParametroGeralEnum.GERACAO_CARNEPARCELAMENTO_OXY, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        if (SimNao.SIM.getSigla().equals(parametroGeracaoCarneparcelamentoOxy.getValor())) {
            return ResponseEntity.ok((Object)this.parcelamentoService.findParcelamentoDebitoParcelas(idParcelamentos));
        }
        return ResponseEntity.ok(Collections.emptyList());
    }

    @GetMapping(value={"/{idParcelamento}/parcelamentos-compativeis"})
    public ResponseEntity<List<ParcelamentoPassivelQuitacaoDTO>> findParcelamentosCompativeis(@PathVariable Long idParcelamento) {
        return ResponseEntity.ok((Object)this.aiseParcelamentoService.findParcelamentosCompativeis(idParcelamento));
    }

    @PostMapping(value={"/simular-quitar-contrato"})
    public ResponseEntity<SimularQuitarContratoDTO> simularQuitarContrato(@RequestBody RequestSimularQuitarContratoDTO request) {
        return ResponseEntity.ok((Object)this.aiseParcelamentoService.simularQuitarContrato(request));
    }

    @PostMapping(value={"/imprimir-simulacao-quitar-contrato"})
    public void imprimirSimulacaoQuitarContrato(@RequestBody SimularQuitarContratoDTO request, HttpServletResponse response) throws IOException {
        byte[] arquivo = this.aiseParcelamentoService.imprimirSimulacaoQuitarContrato(request);
        if (arquivo == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "O relat\u00f3rio est\u00e1 inv\u00e1lido");
        }
        ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])arquivo, (String)ARQUIVO_SIMULACAO_QUITACAO);
    }

    @PostMapping(value={"/quitar-contrato"})
    public ResponseEntity<BloquetoDTO> quitarContrato(@RequestBody RequestSimularQuitarContratoDTO request) {
        return ResponseEntity.ok((Object)this.aiseParcelamentoService.quitarContrato(request));
    }

    @PostMapping(value={"/imprimir-boleto"})
    public ResponseEntity<Object> imprimirBoleto(@Valid @RequestBody ImpressaoBoletoParcelamentoDTO request, HttpServletResponse response) throws IOException {
        byte[] arquivo = null;
        ParametroGeral parametroGeracaoCarneparcelamentoOxy = this.parametroGeralService.findByParametroAndModulo(ParametroGeralEnum.GERACAO_CARNEPARCELAMENTO_OXY, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        if (SimNao.SIM.getSigla().equals(parametroGeracaoCarneparcelamentoOxy.getValor()) && request.getQuantidadeParcelas() > PARCELA_UNICA) {
            ImpressaoCarneParcelamentoDTO impressaoCarneParcelamentoDTO = this.parcelamentoService.gerarOuImprimirBoleto(request, true);
            if (Boolean.TRUE.equals(impressaoCarneParcelamentoDTO.getTarefaEmProcessamento())) {
                return ResponseEntity.noContent().build();
            }
            arquivo = this.aiseParcelamentoService.imprimirCarneParcelamentoAise(ImpressaoBoletoParcelamentoDTO.of((ImpressaoCarneParcelamentoDTO)impressaoCarneParcelamentoDTO));
        } else {
            arquivo = this.aiseParcelamentoService.imprimirBoleto(request);
        }
        if (arquivo == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "N\u00e3o foi poss\u00edvel gerar o boleto.");
        }
        ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])arquivo, (String)ARQUIVO_IMPRESSAO_BOLETO);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/numero-parcelas-boleto"})
    public ResponseEntity<NumeroParcelasImpressaoBoletoDTO> getNumeroParcelasImpressaoBoleto(@Valid @RequestBody BuscarNumeroParcelasImpressaoBoletoDTO request) {
        return ResponseEntity.ok((Object)this.aiseParcelamentoService.buscarNumeroParcelasImpressaoBoleto(request));
    }

    @GetMapping(value={"{idParcelamento}/imprimir-contrato"})
    public void imprimirContrato(@PathVariable Long idParcelamento, HttpServletResponse response) throws IOException {
        ImprimirRelatorioDTO dto = this.parcelamentoService.getImprimirContratoDTO(idParcelamento);
        this.relatorioResource.imprimirRelatorioGenerico(dto, response);
    }

    @GetMapping(value={"/{tenant}/{idParcelamento}/imprimir-contrato"})
    public void imprimirContratoParcelamento(@PathVariable String tenant, @PathVariable Long idParcelamento, HttpServletResponse response) throws IOException {
        byte[] arquivo = this.parcelamentoService.imprimirContratoParcelamentoFromTenant(tenant, idParcelamento);
        if (arquivo == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "N\u00e3o foi poss\u00edvel gerar o contrato de parcelamento.");
        }
        ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])arquivo, (String)ARQUIVO_CONTRATO_PARCELAMENTO);
    }

    @GetMapping(value={"{idParcelamento}/imprimir-situacao-contrato"})
    public void imprimirSituacaoContrato(@PathVariable Long idParcelamento, HttpServletResponse response) throws IOException {
        ImprimirRelatorioDTO dto = this.parcelamentoService.getImprimirSituacaoContratoDTO(idParcelamento);
        this.relatorioResource.imprimirRelatorioGenerico(dto, response);
    }

    @GetMapping(value={"{idParcelamento}/estornos"})
    public ResponseEntity<List<EstornoParcelamentoRowDTO>> getEstornos(@PathVariable Long idParcelamento) {
        return ResponseEntity.ok((Object)this.parcelamentoService.getEstornos(idParcelamento));
    }

    @GetMapping(value={"/{idParcelamento}/resumo"})
    public ResponseEntity<ParcelamentoDTO> getResumo(@PathVariable Long idParcelamento) {
        return ResponseEntity.ok((Object)this.parcelamentoService.getResumo(idParcelamento));
    }

    @GetMapping(value={"/{idParcelamento}/imprimir-carne"})
    public void imprimirCarne(@PathVariable Long idParcelamento, HttpServletResponse response) throws IOException {
        byte[] arquivo = null;
        ParametroGeral parametroGeracaoCarneparcelamentoOxy = this.parametroGeralService.findByParametroAndModulo(ParametroGeralEnum.GERACAO_CARNEPARCELAMENTO_OXY, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        if (SimNao.SIM.getSigla().equals(parametroGeracaoCarneparcelamentoOxy.getValor())) {
            ImpressaoCarneParcelamentoDTO impressaoCarneParcelamentoDTO = this.parcelamentoService.gerarOuImprimirBoleto(idParcelamento, false);
            arquivo = this.aiseParcelamentoService.imprimirCarneParcelamentoAise(ImpressaoBoletoParcelamentoDTO.of((ImpressaoCarneParcelamentoDTO)impressaoCarneParcelamentoDTO));
        } else {
            arquivo = this.aiseParcelamentoService.imprimirCarne(idParcelamento);
        }
        if (arquivo == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "N\u00e3o foi poss\u00edvel gerar o boleto.");
        }
        ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])arquivo, (String)ARQUIVO_IMPRESSAO_BOLETO);
    }

    @GetMapping(value={"/{chave}/{parcelaInicial}/{parcelaFinal}/imprimir-carne"})
    public void imprimirCarneByChave(@PathVariable String chave, @PathVariable Long parcelaInicial, @PathVariable Long parcelaFinal, HttpServletResponse response) throws IOException {
        List parcelamentoCarne = this.parcelamentoCarneService.getByChaveAndParcela(chave, parcelaInicial, parcelaFinal);
        if (Objects.isNull(parcelamentoCarne) || parcelamentoCarne.size() == 0) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, String.format("Nenhum carne de parcelamento gerado para o carn\u00ea %s e parcela %d at\u00e9 %d.", chave, parcelaInicial, parcelaFinal));
        }
        ImpressaoCarneParcelamentoDTO impressaoCarneDto = ImpressaoCarneParcelamentoDTO.from((ParcelamentoCarne)((ParcelamentoCarne)parcelamentoCarne.get(0)), (Long)parcelaInicial, (Long)parcelaFinal);
        byte[] arquivo = this.aiseParcelamentoService.imprimirCarneParcelamentoAise(ImpressaoBoletoParcelamentoDTO.of((ImpressaoCarneParcelamentoDTO)impressaoCarneDto));
        if (arquivo == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "N\u00e3o foi poss\u00edvel gerar o boleto.");
        }
        ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])arquivo, (String)ARQUIVO_IMPRESSAO_BOLETO);
    }

    @PostMapping(value={"/filtro-estorno-parcelamento-em-lote"})
    public ResponseEntity<Page<EstornoParcelamentoEmLoteDTO>> findListaEstornoEmLote(@RequestBody FiltroEstornoParcelamentoEmLoteDTO filtroEstornoParcelamentoEmLoteDTO, Pageable pageable) {
        return ResponseEntity.ok((Object)this.parcelamentoService.filtroEstornoParcelamentoEmLote(filtroEstornoParcelamentoEmLoteDTO, pageable));
    }

    @PostMapping(value={"/geracao-parcelamento"})
    public void generateParcelamentoAssincrono(@Valid @RequestBody SimulacaoParcelamentoDTO param) {
        param.setHeaderAtendimento(this.historicoAtendimentoService.getHeaderAtendimento());
        Boolean tarefaEmExecucao = this.tarefaAssincronaService.existsProcessoEmExecucao(TipoTarefaAssincrona.GERACAO_PARCELAMENTO, "ID_PARCELAMENTO_ASSINCRONO", SimulacaoParcelamentoDTO.getChaveParcelamentoAssincrono((SimulacaoParcelamentoDTO)param));
        if (Boolean.TRUE.equals(tarefaEmExecucao)) {
            throw new EloValidationException("J\u00e1 existe uma tarefa em execu\u00e7\u00e3o para parcelamento do cadastro informado.");
        }
        UserSecurityDTO userSecurityDTO = SecurityUtils.getUserSecurityDTO();
        if (Objects.isNull(userSecurityDTO.getUserId())) {
            throw new UserNotFoundException("Usu\u00e1rio logado n\u00e3o encontrado.");
        }
        this.aiseParcelamentoService.createGeracaoParcelamentoAssincrono(param, userSecurityDTO);
    }

    @PostMapping(value={"/situacao/{situacao}"})
    public ResponseEntity<Page<ParcelamentoListItem>> getParcelamentosBySituacao(@PathVariable(name="situacao") String situacao, @RequestBody FiltroMultiValueParcelamento filtros, Pageable pageable) {
        SituacaoParcelamentoEnum situacaoEnum = SituacaoParcelamentoEnum.valueOf((String)situacao.toUpperCase());
        Page parcelamentos = this.parcelamentoService.findPaginatedParcelamentosBySituacao(situacaoEnum, filtros, pageable);
        return ResponseEntity.ok((Object)parcelamentos);
    }

    @GetMapping(value={"/{id}/pode-imprimir-carne"})
    public ResponseEntity<Boolean> podeImprimirCarne(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.parcelamentoService.podeImprimirCarneCompleto(id));
    }

    @Generated
    public ParcelamentoResource(ParcelamentoService parcelamentoService, ParcelamentoCarneService parcelamentoCarneService, AiseParcelamentoService aiseParcelamentoService, RelatorioResource relatorioResource, ParametroGeralService parametroGeralService, TarefaAssincronaService tarefaAssincronaService, HistoricoAtendimentoService historicoAtendimentoService) {
        this.parcelamentoService = parcelamentoService;
        this.parcelamentoCarneService = parcelamentoCarneService;
        this.aiseParcelamentoService = aiseParcelamentoService;
        this.relatorioResource = relatorioResource;
        this.parametroGeralService = parametroGeralService;
        this.tarefaAssincronaService = tarefaAssincronaService;
        this.historicoAtendimentoService = historicoAtendimentoService;
    }
}

