/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.ParametroGeral;
import br.com.elotech.tributos.service.ParametroGeralService;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/parametros-gerais"})
public class ParametroGeralResource
extends CrudResource<ParametroGeral, Long> {
    private final ParametroGeralService parametroGeralService;

    @GetMapping(params={"modulo", "parametro"})
    public ResponseEntity<ParametroGeral> findOne(@RequestParam(value="modulo") String modulo, @RequestParam(value="parametro") String parametro) {
        return ResponseEntity.ok((Object)this.parametroGeralService.findByParametroAndModulo(parametro, modulo));
    }

    @GetMapping(value={"/group-by-parametro"})
    public ResponseEntity<Map<String, ParametroGeral>> findByParametros(@RequestParam(value="modulo") String modulo, @RequestParam(value="parametros") List<String> parametros) {
        return ResponseEntity.ok((Object)this.parametroGeralService.findByModuloAndParametroIn(modulo, parametros));
    }

    @PutMapping(value={"/update-all"})
    public ResponseEntity<Void> updateAll(@RequestBody List<ParametroGeral> parametros) {
        this.parametroGeralService.updateAll(parametros);
        return ResponseEntity.ok().build();
    }

    @Generated
    public ParametroGeralResource(ParametroGeralService parametroGeralService) {
        this.parametroGeralService = parametroGeralService;
    }
}

