/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.PagamentoNegociado;
import br.com.elotech.tributos.dto.BloquetoDTO;
import br.com.elotech.tributos.dto.DebitoPagamentoNegociadoComTotalizadorDTO;
import br.com.elotech.tributos.dto.FiltroConsultaDebitoPagamentoNegociado;
import br.com.elotech.tributos.dto.FiltroSimulacaoPagamentoNegociadoDTO;
import br.com.elotech.tributos.dto.PagamentoNegociadoDTO;
import br.com.elotech.tributos.dto.PagamentoNegociadoDebitoDTO;
import br.com.elotech.tributos.dto.ParametrosPagamentoNegociadoDTO;
import br.com.elotech.tributos.dto.negociacaodebito.EstornoNegociacaoDebitoParamsDTO;
import br.com.elotech.tributos.service.PagamentoNegociadoService;
import br.com.elotech.tributos.service.PgtoNegociadoDebOrigemService;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pagamento-negociado"})
public class PagamentoNegociadoResource {
    private final PagamentoNegociadoService pagamentoNegociadoService;
    private final PgtoNegociadoDebOrigemService pgtoNegociadoDebOrigemService;

    @GetMapping
    public ResponseEntity<Page<PagamentoNegociadoDTO>> findAll(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        Page pagamentos = this.pagamentoNegociadoService.findByRsql(search, pageable);
        return ResponseEntity.ok((Object)pagamentos.map(PagamentoNegociadoDTO::basicFrom));
    }

    @GetMapping(value={"/{id}/resumo"})
    public ResponseEntity<PagamentoNegociadoDTO> resumo(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.pagamentoNegociadoService.findById((Serializable)id).map(PagamentoNegociadoDTO::completeFrom).orElseThrow(() -> RestException.notFound((String)String.format("N\u00e3o foi poss\u00edvel encontrar o pagamento negociado de id %d.", id))));
    }

    @GetMapping(value={"/debitos"})
    public ResponseEntity<DebitoPagamentoNegociadoComTotalizadorDTO> findDebitos(@Valid FiltroConsultaDebitoPagamentoNegociado filtro) {
        return ResponseEntity.ok((Object)this.pagamentoNegociadoService.findDebitos(filtro));
    }

    @PostMapping(value={"/simular"})
    public ResponseEntity<DebitoPagamentoNegociadoComTotalizadorDTO> simularPagamentoNegociado(@RequestBody @Valid FiltroSimulacaoPagamentoNegociadoDTO filtro) {
        return ResponseEntity.ok((Object)this.pagamentoNegociadoService.gerarSimulacaoPagamentoNegociado(filtro));
    }

    @Transactional
    @PostMapping(value={"/gerar"})
    public ResponseEntity<PagamentoNegociado> gerar(@RequestBody @Valid ParametrosPagamentoNegociadoDTO parametrosPagamentoNegociadoDTO) {
        return ResponseEntity.ok((Object)this.pagamentoNegociadoService.gerar(parametrosPagamentoNegociadoDTO));
    }

    @Transactional
    @PostMapping(value={"/estornar/{id}"})
    public ResponseEntity<PagamentoNegociado> estornar(@PathVariable(value="id") Long id, @RequestBody @Valid EstornoNegociacaoDebitoParamsDTO dto) {
        return ResponseEntity.ok((Object)this.pagamentoNegociadoService.estornar(id, dto));
    }

    @Transactional
    @PostMapping(value={"/reemitir-boleto/{id}"})
    public ResponseEntity<List<BloquetoDTO>> reemitirBoleto(@PathVariable(value="id") Long id, @RequestParam(value="dataVencimento") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate dataVencimento) {
        return ResponseEntity.ok((Object)this.pagamentoNegociadoService.reemitirBoleto(id, dataVencimento));
    }

    @GetMapping(value={"/debitos-origem-negociados"})
    public ResponseEntity<Page<PagamentoNegociadoDebitoDTO>> findAllDebitosOrigem(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        Page debitos = this.pgtoNegociadoDebOrigemService.findByRsql(search, pageable);
        return ResponseEntity.ok((Object)debitos.map(PagamentoNegociadoDebitoDTO::from));
    }

    @Generated
    public PagamentoNegociadoResource(PagamentoNegociadoService pagamentoNegociadoService, PgtoNegociadoDebOrigemService pgtoNegociadoDebOrigemService) {
        this.pagamentoNegociadoService = pagamentoNegociadoService;
        this.pgtoNegociadoDebOrigemService = pgtoNegociadoDebOrigemService;
    }
}

