/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.Livro;
import br.com.elotech.tributos.domain.LivroId;
import br.com.elotech.tributos.dto.ImprimirRelatorioDTO;
import br.com.elotech.tributos.dto.dividaativa.LivroDTO;
import br.com.elotech.tributos.resource.RelatorioResource;
import br.com.elotech.tributos.service.LivroService;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/livros"})
public class LivroResource
extends CrudResource<Livro, LivroId> {
    private final LivroService livroService;
    private final RelatorioResource relatorioResource;

    public LivroResource(LivroService livroService, RelatorioResource relatorioResource) {
        this.livroService = livroService;
        this.relatorioResource = relatorioResource;
    }

    @GetMapping(value={"/search"})
    public ResponseEntity<Page<LivroDTO>> getLivros(@RequestParam Optional<String> search, Pageable page) {
        return ResponseEntity.ok((Object)this.livroService.getLivros((String)search.orElse(null), page));
    }

    @GetMapping(value={"/{entidade}/{exercicio}/{livro}/resumo"})
    public ResponseEntity<LivroDTO> getLivroResumo(@PathVariable(value="entidade") Long entidade, @PathVariable(value="exercicio") Long exercicio, @PathVariable(value="livro") Long livro) {
        return ResponseEntity.ok((Object)this.livroService.getLivroResumo(entidade, exercicio, livro));
    }

    @GetMapping(value={"/{entidade}/{exercicio}/{livro}/imprimir"})
    public void imprimirLivro(@PathVariable(value="entidade") Long entidade, @PathVariable(value="exercicio") Long exercicio, @PathVariable(value="livro") Long livro, HttpServletResponse response) throws IOException {
        ImprimirRelatorioDTO imprimirRelatorioDTO = this.livroService.getImprimirLivro(entidade, exercicio, livro);
        this.relatorioResource.imprimirRelatorioGenerico(imprimirRelatorioDTO, response);
    }
}

