/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.domain.ConfigHonorario;
import br.com.elotech.tributos.dto.CertidaoDividaAtivaDebitoHonorarioDTO;
import br.com.elotech.tributos.dto.ConfigHonorarioDTO;
import br.com.elotech.tributos.service.honorarios.CertidaoDividaAtivaDebitoHistoricoService;
import br.com.elotech.tributos.service.honorarios.ConfigHonorarioService;
import br.com.elotech.tributos.service.honorarios.GerarHonorarioCdaService;
import br.com.elotech.tributos.service.honorarios.GerarHonorarioLoteService;
import br.com.elotech.tributos.service.honorarios.GerarHonorarioPeticaoService;
import java.util.List;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/honorarios"})
public class GerarHonorarioResource {
    private final GerarHonorarioLoteService gerarHonorarioLoteService;
    private final CertidaoDividaAtivaDebitoHistoricoService certidaoDividaAtivaDebitoHistoricoService;
    private final GerarHonorarioPeticaoService gerarHonorarioPeticaoService;
    private final GerarHonorarioCdaService gerarHonorarioCdaService;
    private final ConfigHonorarioService configHonorarioService;

    @PostMapping(value={"/{id}/gerar-debito-lote/{percentual}"})
    public ResponseEntity<Void> gerarDebitoLotePeticao(@PathVariable Long id, @PathVariable Double percentual) {
        this.gerarHonorarioLoteService.createTarefaGerarHonorarioByLote(id, percentual);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/{id}/historico"})
    public ResponseEntity<List<CertidaoDividaAtivaDebitoHonorarioDTO>> consultaHistoricoDebitoHonorariosCda(@PathVariable(value="id") Long idDocumento) {
        return ResponseEntity.ok((Object)this.certidaoDividaAtivaDebitoHistoricoService.getCdaDebitoHonorarioByDocumentoId(idDocumento));
    }

    @PostMapping(value={"/{id}/gerar-debito-peticao/{percentual}"})
    public ResponseEntity<Void> gerarDebitoPeticao(@PathVariable Long id, @PathVariable Double percentual) {
        this.gerarHonorarioPeticaoService.createTarefaGerarHonorarioByPeticao(id, percentual);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/{id}/gerar-debito-certidao/{percentual}"})
    public ResponseEntity<Void> gerarDebitoCertidao(@PathVariable Long id, @PathVariable Double percentual) {
        this.gerarHonorarioCdaService.createTarefaGerarHonorarioByCertidao(id, percentual);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/{exercicio}/configuracao"})
    public ResponseEntity<ConfigHonorarioDTO> consultaConfiguracaoHonorario(@PathVariable(value="exercicio") Long exercicio) {
        return ResponseEntity.ok((Object)ConfigHonorarioDTO.from((ConfigHonorario)this.configHonorarioService.findByExercicio(exercicio)));
    }

    @Generated
    public GerarHonorarioResource(GerarHonorarioLoteService gerarHonorarioLoteService, CertidaoDividaAtivaDebitoHistoricoService certidaoDividaAtivaDebitoHistoricoService, GerarHonorarioPeticaoService gerarHonorarioPeticaoService, GerarHonorarioCdaService gerarHonorarioCdaService, ConfigHonorarioService configHonorarioService) {
        this.gerarHonorarioLoteService = gerarHonorarioLoteService;
        this.certidaoDividaAtivaDebitoHistoricoService = certidaoDividaAtivaDebitoHistoricoService;
        this.gerarHonorarioPeticaoService = gerarHonorarioPeticaoService;
        this.gerarHonorarioCdaService = gerarHonorarioCdaService;
        this.configHonorarioService = configHonorarioService;
    }
}

