/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.tributos.domain.Livro;
import br.com.elotech.tributos.domain.LivroId;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.dto.dividaativa.FiltroGeraLivroDTO;
import br.com.elotech.tributos.dto.dividaativa.GeraLivroDebitoParcelaDTO;
import br.com.elotech.tributos.enums.TipoLivroDividaAtiva;
import br.com.elotech.tributos.repository.GeraLivroRepository;
import br.com.elotech.tributos.service.GeraLivroDividaAtivaService;
import br.com.elotech.tributos.service.LivroService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.ValidaDataMovimentacaoService;
import br.com.elotech.tributos.service.batch.LivroDividaAtivaJobStarter;
import java.io.Serializable;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/gera-livro-divida-ativa"})
public class GeraLivroResource {
    private final ParametroGeralService parametroGeralService;
    private final GeraLivroRepository geraLivroRepository;
    private final LivroDividaAtivaJobStarter livroDividaAtivaJobStarter;
    private final ValidaDataMovimentacaoService validaDataMovimentacaoService;
    private final GeraLivroDividaAtivaService geraLivroDividaAtivaService;
    private final LivroService livroService;

    @PostMapping(value={"/filtrar-debitos"})
    public ResponseEntity<Page<GeraLivroDebitoParcelaDTO>> search(@RequestBody FiltroGeraLivroDTO filtro, Pageable pageable) {
        this.validaDataMovimentacaoService.validaMesEDia(filtro.getEntidade(), filtro.getDataInscricao());
        Boolean inscricaoPorParcela = "P".equals(this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.TIPO_INSCRICAO_DIVIDA_ATIVA, ModuloEnum.MODULO_TRIBUTARIO.getValue()));
        Page result = this.geraLivroRepository.getDebitoParcelas(filtro.getFiltro(inscricaoPorParcela), pageable, filtro.getEntidade());
        return ResponseEntity.ok((Object)result);
    }

    @PostMapping
    public ResponseEntity<Void> geraLivroDividaAtiva(@Valid @RequestBody FiltroGeraLivroDTO filtro) {
        this.validaDataMovimentacaoService.validaMesEDia(filtro.getEntidade(), filtro.getDataInscricao());
        this.livroDividaAtivaJobStarter.startJob(filtro, TipoLivroDividaAtiva.EFETIVO, null, null);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/simular"})
    public ResponseEntity<Void> simularLivroDividaAtiva(@Valid @RequestBody FiltroGeraLivroDTO filtro) {
        this.validaDataMovimentacaoService.validaMesEDia(filtro.getEntidade(), filtro.getDataInscricao());
        this.livroDividaAtivaJobStarter.startJob(filtro, TipoLivroDividaAtiva.SIMULACAO, null, null);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/{entidade}/{exercicio}/{livro}/efetivar"})
    public ResponseEntity<Void> efetivarSimulacao(@PathVariable(name="entidade") Long entidade, @PathVariable(name="exercicio") Long exercicio, @PathVariable(name="livro") Long livro) {
        LivroId idLivro = LivroId.of((Long)entidade, (Long)exercicio, (Long)livro);
        Livro livroEntity = (Livro)this.livroService.findOne((Serializable)idLivro);
        if (livroEntity.isEfetivo()) {
            return ResponseEntity.unprocessableEntity().build();
        }
        FiltroGeraLivroDTO filtro = this.geraLivroDividaAtivaService.getFiltroByLivro(livroEntity);
        this.livroDividaAtivaJobStarter.startJob(filtro, TipoLivroDividaAtiva.EFETIVO, idLivro, null);
        return ResponseEntity.ok().build();
    }

    @Generated
    public GeraLivroResource(ParametroGeralService parametroGeralService, GeraLivroRepository geraLivroRepository, LivroDividaAtivaJobStarter livroDividaAtivaJobStarter, ValidaDataMovimentacaoService validaDataMovimentacaoService, GeraLivroDividaAtivaService geraLivroDividaAtivaService, LivroService livroService) {
        this.parametroGeralService = parametroGeralService;
        this.geraLivroRepository = geraLivroRepository;
        this.livroDividaAtivaJobStarter = livroDividaAtivaJobStarter;
        this.validaDataMovimentacaoService = validaDataMovimentacaoService;
        this.geraLivroDividaAtivaService = geraLivroDividaAtivaService;
        this.livroService = livroService;
    }
}

