/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.service.batch.EnvioLotePeticaoProcuradoriaStarter;
import br.com.elotech.tributos.service.documento.EnviarPeticaoService;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/envio-peticoes"})
public class EnvioPeticaoResource {
    private final EnviarPeticaoService enviarPeticaoService;
    private final EnvioLotePeticaoProcuradoriaStarter envioPeticaoProcuradoriaStarter;

    @PostMapping(value={"/{idPeticao}"})
    public ResponseEntity<Void> enviarPeticaoProcuradoria(@PathVariable Long idPeticao) throws IOException {
        this.enviarPeticaoService.agruparArquivoPeticaoLoteCda(idPeticao);
        return ResponseEntity.ok().build();
    }

    @PostMapping
    public ResponseEntity<Map<String, Object>> enviarPeticoesProcuradoria(@RequestBody List<Long> idsPeticoes) {
        return ResponseEntity.ok((Object)this.enviarPeticaoService.enviarPeticoesProcuradoria(idsPeticoes));
    }

    @PostMapping(value={"/lote/{idLote}"})
    public ResponseEntity<Void> enviarLotePeticaoProcuradoria(@PathVariable Long idLote) throws IOException, JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException {
        this.envioPeticaoProcuradoriaStarter.startJob(idLote);
        return ResponseEntity.ok().build();
    }

    @Generated
    public EnvioPeticaoResource(EnviarPeticaoService enviarPeticaoService, EnvioLotePeticaoProcuradoriaStarter envioPeticaoProcuradoriaStarter) {
        this.enviarPeticaoService = enviarPeticaoService;
        this.envioPeticaoProcuradoriaStarter = envioPeticaoProcuradoriaStarter;
    }
}

