/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.domain.PagamentoId;
import br.com.elotech.tributos.dto.devolucaocredito.DevolucaoCreditoItemDTO;
import br.com.elotech.tributos.service.DevolucaoCreditoItemService;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/devolucao-credito-item"})
public class DevolucaoCreditoItemResource {
    private final DevolucaoCreditoItemService devolucaoCreditoItemService;

    @GetMapping(value={"/credito"})
    public ResponseEntity<Page<DevolucaoCreditoItemDTO>> getPagamentoCreditosParaDevolucoes(@RequestParam(value="search", required=false, defaultValue="") String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.devolucaoCreditoItemService.getPagamentosCreditoParaDevolucoes(search, pageable));
    }

    @GetMapping(value={"/pagamento"})
    public ResponseEntity<Page<DevolucaoCreditoItemDTO>> getPagamentosParaDevolucoes(@RequestParam(value="search", required=false, defaultValue="") String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.devolucaoCreditoItemService.getPagamentosParaDevolucoes(search, pageable));
    }

    @GetMapping(value={"/by-pagamento"})
    public ResponseEntity<DevolucaoCreditoItemDTO> getDevolucaoCreditoItemToDevolucao(PagamentoId id) {
        DevolucaoCreditoItemDTO devolucao = this.devolucaoCreditoItemService.getDevolucaoCreditoItemDTOToDevolucao(id);
        if (devolucao == null) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.ok((Object)devolucao);
    }

    @GetMapping(value={"/is-refund"})
    public ResponseEntity<Boolean> isPagamentoRefundable(PagamentoId id) {
        Boolean isRefundable = this.devolucaoCreditoItemService.pagamentoIsRefundable(id);
        return ResponseEntity.ok((Object)isRefundable);
    }

    @Generated
    public DevolucaoCreditoItemResource(DevolucaoCreditoItemService devolucaoCreditoItemService) {
        this.devolucaoCreditoItemService = devolucaoCreditoItemService;
    }
}

