/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.DebitoParcelaId;
import br.com.elotech.tributos.dto.DebitoDetalheParcelasDTO;
import br.com.elotech.tributos.dto.DebitoParcelaDTO;
import br.com.elotech.tributos.dto.ProcessoAjuizadoDTO;
import br.com.elotech.tributos.service.DebitoParcelaService;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/debitos-parcela"})
public class DebitoParcelaResource
extends CrudResource<DebitoParcela, DebitoParcelaId> {
    private final DebitoParcelaService debitoParcelaService;

    public DebitoParcelaResource(DebitoParcelaService debitoParcelaService) {
        this.debitoParcelaService = debitoParcelaService;
    }

    @PutMapping(value={"/salvar"})
    @Transactional
    public ResponseEntity<DebitoParcela> updateParcela(@RequestBody @Valid DebitoDetalheParcelasDTO debitoDetalheParcelasDTO) {
        return ResponseEntity.ok((Object)this.debitoParcelaService.updateParcela(debitoDetalheParcelasDTO));
    }

    @PutMapping(value={"/replicar-parcelas"})
    @Transactional
    public ResponseEntity<List<DebitoParcela>> updateParcelas(@RequestBody @Valid DebitoDetalheParcelasDTO debitoDetalheParcelasDTO) {
        return ResponseEntity.ok((Object)this.debitoParcelaService.updateParcelas(debitoDetalheParcelasDTO));
    }

    @GetMapping(value={"/debitos-inclusao"})
    public ResponseEntity<Page<DebitoParcelaDTO>> findValidDebtsForInclusion(@RequestParam Long tipoCadastro, @RequestParam Long cadastroGeral, @RequestParam String search, Pageable page) {
        Page result = this.debitoParcelaService.findValidDebtsForInclusion(tipoCadastro, cadastroGeral, search, page);
        Page resultDto = result.map(DebitoParcelaDTO::from);
        return ResponseEntity.ok((Object)resultDto);
    }

    @PutMapping(value={"/atualizar-processo-judicial"})
    public Map<Long, List<Long>> receberProcessoJudicial(@RequestBody ProcessoAjuizadoDTO processo) {
        return this.debitoParcelaService.atualizarProcessoJudicial(processo);
    }
}

