/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.core.utils.web.ResponseUtils;
import br.com.elotech.tributos.domain.DebitoAutomaticoRemessa;
import br.com.elotech.tributos.dto.debitoautomatico.RemessaDebitoAutomaticoFilterDTO;
import br.com.elotech.tributos.service.DebitoAutomaticoRemessaService;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/debito-automatico-remessa"})
public class DebitoAutomaticoRemessaResource
extends CrudResource<DebitoAutomaticoRemessa, Long> {
    private final DebitoAutomaticoRemessaService debitoAutomaticoRemessaService;

    @PostMapping(value={"/importar-arquivos"})
    public ResponseEntity<Void> importarArquivos(@RequestParam(value="files") List<MultipartFile> arquivos) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException {
        this.debitoAutomaticoRemessaService.importarArquivos(arquivos);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/gerar-remessa"})
    public ResponseEntity<Void> gerarRemessa(@RequestBody RemessaDebitoAutomaticoFilterDTO filtro) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException, JsonProcessingException {
        this.debitoAutomaticoRemessaService.gerarRemessa(filtro);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/regerar-remessa"})
    public ResponseEntity<Void> gerarRemessa(@RequestParam(value="idRemessa") Long idRemessa) {
        this.debitoAutomaticoRemessaService.regerarRemessa(idRemessa);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/gerar-arquivo"})
    public void gerarArquivo(@RequestParam(value="idRemessa") Long idRemessa, HttpServletResponse response) throws IOException {
        byte[] arquivo = this.debitoAutomaticoRemessaService.gerarArquivo(idRemessa);
        ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])arquivo, (String)String.format("remessa-debito-automatico-%d.rem", idRemessa));
    }

    @Generated
    public DebitoAutomaticoRemessaResource(DebitoAutomaticoRemessaService debitoAutomaticoRemessaService) {
        this.debitoAutomaticoRemessaService = debitoAutomaticoRemessaService;
    }
}

