/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.DebitoAutomaticoArquivoConfirmacao;
import br.com.elotech.tributos.dto.DebitoAutomaticoArquivoConfirmacaoDTO;
import br.com.elotech.tributos.dto.DebitoAutomaticoInconsistenciaDTO;
import br.com.elotech.tributos.service.DebitoAutomaticoArquivoConfirmacaoService;
import br.com.elotech.tributos.service.DebitoAutomaticoInconsistenciaService;
import br.com.elotech.tributos.service.DebitoAutomaticoRemessaInconsistenciaService;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/debito-automatico-confirmacao"})
public class DebitoAutomaticoArquivoConfirmacaoResource
extends CrudResource<DebitoAutomaticoArquivoConfirmacao, Long> {
    private final DebitoAutomaticoRemessaInconsistenciaService debitoAutomaticoRemessaInconsistenciaService;
    private final DebitoAutomaticoInconsistenciaService debitoAutomaticoInconsistenciaService;
    private final DebitoAutomaticoArquivoConfirmacaoService debitoAutomaticoArquivoConfirmacaoService;

    @PostMapping(value={"/gerar-arquivo-inconsistencia"})
    public void gerarArquivoInconsistencia(@RequestParam(value="idArquivo") Long idArquivo, HttpServletResponse response) throws IOException {
        String conteudo = this.debitoAutomaticoRemessaInconsistenciaService.gerarRemessaInconsistencia(idArquivo);
        byte[] arquivo = conteudo.getBytes(StandardCharsets.UTF_8);
        response.setContentType("text/plain; charset=UTF-8");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"remessa-inconsistencia-%d.txt\"", idArquivo));
        response.getOutputStream().write(arquivo);
        response.getOutputStream().flush();
    }

    @GetMapping(value={"/{id}/inconsistencias"})
    public ResponseEntity<List<DebitoAutomaticoInconsistenciaDTO>> consultaInconsistencisa(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.debitoAutomaticoInconsistenciaService.consultaInconsistencias(id));
    }

    @GetMapping(value={"/search"})
    public ResponseEntity<Page<DebitoAutomaticoArquivoConfirmacaoDTO>> findAllArquivos(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.debitoAutomaticoArquivoConfirmacaoService.findAllArquivos(search, pageable));
    }

    @Generated
    public DebitoAutomaticoArquivoConfirmacaoResource(DebitoAutomaticoRemessaInconsistenciaService debitoAutomaticoRemessaInconsistenciaService, DebitoAutomaticoInconsistenciaService debitoAutomaticoInconsistenciaService, DebitoAutomaticoArquivoConfirmacaoService debitoAutomaticoArquivoConfirmacaoService) {
        this.debitoAutomaticoRemessaInconsistenciaService = debitoAutomaticoRemessaInconsistenciaService;
        this.debitoAutomaticoInconsistenciaService = debitoAutomaticoInconsistenciaService;
        this.debitoAutomaticoArquivoConfirmacaoService = debitoAutomaticoArquivoConfirmacaoService;
    }
}

