/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.domain.ConsultaDebito;
import br.com.elotech.tributos.domain.ConsultaDebitoTipoAgrupamento;
import br.com.elotech.tributos.dto.ConsultaDebitoItemDTO;
import br.com.elotech.tributos.dto.ConsultaDebitoValoresDTO;
import br.com.elotech.tributos.dto.FiltroConsultaDebitoDTO;
import br.com.elotech.tributos.enums.TipoArquivoRelatorioEnum;
import br.com.elotech.tributos.service.ConsultaDebitoBatchService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.batch.ConsultaDebitoJobStarter;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.query.Param;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/consulta-debito"})
public class ConsultaDebitoResource {
    private final ConsultaDebitoJobStarter consultaDebitoJobStarter;
    private final ConsultaDebitoBatchService consultaDebitoBatchService;
    private final DebitoService debitoService;
    private final ContextService contextService;

    @PostMapping
    public ResponseEntity<ConsultaDebito> consultarDebito(@Valid @RequestBody FiltroConsultaDebitoDTO filtro) throws JobParametersInvalidException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException, JsonProcessingException {
        filtro.setEntidade(this.contextService.getEntidadePrincipal());
        this.debitoService.totalDebitosConstituidos(filtro);
        this.consultaDebitoJobStarter.startJob(filtro);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/{idConsulta}"}, params={"tipoAgrupamento"})
    public ResponseEntity<Page<ConsultaDebitoItemDTO>> findDebitos(@PathVariable Long idConsulta, @Param(value="tipoAgrupamento") String tipoAgrupamento, Pageable pageable) {
        return ResponseEntity.ok((Object)this.consultaDebitoBatchService.getDebitos(idConsulta, tipoAgrupamento, pageable));
    }

    @GetMapping(value={"/{idConsulta}/filtro"})
    public ResponseEntity<FiltroConsultaDebitoDTO> getFiltro(@PathVariable Long idConsulta) throws JsonProcessingException {
        return ResponseEntity.ok((Object)this.consultaDebitoBatchService.getFiltro(idConsulta));
    }

    @GetMapping(value={"/{idConsulta}/resumo"})
    public ResponseEntity<ConsultaDebitoValoresDTO> getResumo(@PathVariable Long idConsulta) {
        return ResponseEntity.ok((Object)this.consultaDebitoBatchService.getResumo(idConsulta));
    }

    @GetMapping(value={"/{idConsulta}/report"})
    public ResponseEntity<byte[]> imprimirExtratoDebitos(@PathVariable Long idConsulta, @RequestParam(value="tipoAgrupamento") String tipoAgrupamento, @RequestParam(value="formatoRelatorio") String formatoRelatorio) throws IOException {
        TipoArquivoRelatorioEnum tipoArquivoRelatorioEnum;
        ConsultaDebitoTipoAgrupamento tipoAgrupamentoEnum = ConsultaDebitoTipoAgrupamento.fromValue((String)tipoAgrupamento);
        byte[] arquivo = this.consultaDebitoBatchService.getArquivoReport(idConsulta, tipoAgrupamentoEnum, tipoArquivoRelatorioEnum = TipoArquivoRelatorioEnum.fromValue((String)formatoRelatorio));
        if (arquivo == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "N\u00e3o foi poss\u00edvel gerar o relat\u00f3rio para a consulta de d\u00e9bitos.");
        }
        HttpHeaders headers = this.consultaDebitoBatchService.builderHeaders(tipoArquivoRelatorioEnum, tipoAgrupamentoEnum, arquivo);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)arquivo);
    }

    @Generated
    public ConsultaDebitoResource(ConsultaDebitoJobStarter consultaDebitoJobStarter, ConsultaDebitoBatchService consultaDebitoBatchService, DebitoService debitoService, ContextService contextService) {
        this.consultaDebitoJobStarter = consultaDebitoJobStarter;
        this.consultaDebitoBatchService = consultaDebitoBatchService;
        this.debitoService = debitoService;
        this.contextService = contextService;
    }
}

