/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.Comunicado;
import br.com.elotech.tributos.domain.ComunicadoId;
import br.com.elotech.tributos.domain.tarefaassincrona.TipoTarefaAssincrona;
import br.com.elotech.tributos.dto.ComunicadoDto;
import br.com.elotech.tributos.dto.comunicado.GerarComunicadoRequest;
import br.com.elotech.tributos.dto.simam.NotificacaoComunicadoContribuinteDTO;
import br.com.elotech.tributos.service.TarefaAssincronaService;
import br.com.elotech.tributos.service.batch.comunicado.ValidacaoEnderecoJobStarter;
import br.com.elotech.tributos.service.comunicado.ComunicadoService;
import br.com.elotech.tributos.service.comunicado.GerarComunicadoManualService;
import java.time.LocalDateTime;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api/comunicados"})
public class ComunicadoResource
extends CrudResource<Comunicado, ComunicadoId> {
    private final ComunicadoService comunicadoService;
    private final GerarComunicadoManualService gerarComunicadoManualService;
    private final ValidacaoEnderecoJobStarter validacaoEnderecoJobStarter;
    private final TarefaAssincronaService tarefaAssincronaService;

    @GetMapping(value={"/id/{entidade}/{exercicio}/{idComunicado}"})
    public ResponseEntity<ComunicadoDto> findOne(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long idComunicado) {
        ComunicadoDto comunicadoDTO = this.comunicadoService.findComunicadoDTOById(ComunicadoId.of((Long)entidade, (Long)exercicio, (Long)idComunicado));
        return ResponseEntity.ok((Object)comunicadoDTO);
    }

    @GetMapping(value={"/search"})
    public ResponseEntity<Page<ComunicadoDto>> searchCampos(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.comunicadoService.search(search, pageable));
    }

    @PostMapping(value={"/{entidade}/{exercicio}/{idComunicado}/valida-enderecos"})
    public ResponseEntity<ComunicadoDto> validateEnderecoComunicadoGlobal(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long idComunicado) throws Exception {
        this.comunicadoService.validateEnderecosGlobais(entidade, exercicio, idComunicado);
        this.validacaoEnderecoJobStarter.startjob(entidade, exercicio, idComunicado, LocalDateTime.now());
        return ResponseEntity.ok().build();
    }

    @PutMapping(value={"/{entidade}/{exercicio}/{idComunicado}/cancelar"})
    public ResponseEntity<ComunicadoDto> cancelarComunicado(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long idComunicado) {
        Comunicado comunicado = this.comunicadoService.cancelComunicado(entidade, exercicio, idComunicado);
        return ResponseEntity.ok((Object)ComunicadoDto.from((Comunicado)comunicado));
    }

    @GetMapping(value={"/{entidade}/{exercicio}/{idComunicado}/imprimir-lote"})
    public Callable<Void> printLoteComunicado(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long idComunicado, @RequestParam(required=false, defaultValue="") String search, Sort sort) {
        return () -> {
            Boolean existsProcessoEmExecucao = this.tarefaAssincronaService.existsProcessoEmExecucao(TipoTarefaAssincrona.IMPRESSAO_COMUNICADO_LOTE, "ID_LOTE_COMUNICADO", ComunicadoId.of((Long)entidade, (Long)exercicio, (Long)idComunicado).toString());
            if (existsProcessoEmExecucao.booleanValue()) {
                throw new EloValidationException("J\u00e1 existe uma tarefa com o par\u00e2metro informado em execu\u00e7\u00e3o.");
            }
            this.comunicadoService.printLoteComunicado(entidade, exercicio, idComunicado, search, sort);
            return null;
        };
    }

    @GetMapping(value={"/{entidade}/{exercicio}/{idComunicado}/download"})
    public ResponseEntity<String> downloadLoteComunicado(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long idComunicado) {
        return ResponseEntity.ok((Object)this.comunicadoService.getUrlArquivoLoteComunicado(entidade, exercicio, idComunicado));
    }

    @PostMapping(value={"/gerar"})
    public ResponseEntity<Void> gerarComunicados(@RequestBody GerarComunicadoRequest request) {
        this.gerarComunicadoManualService.gerarComunicadoManual(request);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/notificar-todos"})
    public ResponseEntity<Void> notificarTodos(@RequestBody NotificacaoComunicadoContribuinteDTO notificacaoDTO) {
        this.comunicadoService.notificarTodos(notificacaoDTO);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/notificar-selecionados"})
    public ResponseEntity<Void> notificarSelecionados(@RequestBody NotificacaoComunicadoContribuinteDTO notificacaoDTO) {
        this.comunicadoService.notificarPorContribuinte(notificacaoDTO);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/{entidade}/{exercicio}/{idComunicado}/pode-imprimir-lote"})
    public ResponseEntity<Boolean> podeImprimirLote(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long idComunicado) {
        return ResponseEntity.ok((Object)this.comunicadoService.podeImprimirLote(ComunicadoId.of((Long)entidade, (Long)exercicio, (Long)idComunicado)));
    }

    @Generated
    public ComunicadoResource(ComunicadoService comunicadoService, GerarComunicadoManualService gerarComunicadoManualService, ValidacaoEnderecoJobStarter validacaoEnderecoJobStarter, TarefaAssincronaService tarefaAssincronaService) {
        this.comunicadoService = comunicadoService;
        this.gerarComunicadoManualService = gerarComunicadoManualService;
        this.validacaoEnderecoJobStarter = validacaoEnderecoJobStarter;
        this.tarefaAssincronaService = tarefaAssincronaService;
    }
}

