/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.utils.web.ResponseUtils;
import br.com.elotech.fluent.ReportDatasource;
import br.com.elotech.fluent.dataset.loader.DatasetLoader;
import br.com.elotech.fluent.dataset.loader.DatasetLoaders;
import br.com.elotech.fluent.dataset.loader.ReportDataLoader;
import br.com.elotech.fluent.param.Param;
import br.com.elotech.fluent.param.ParamLoader;
import br.com.elotech.report.EloReport;
import br.com.elotech.report.EloReportFactory;
import br.com.elotech.report.file.ReportFileResolverFactory;
import br.com.elotech.tributos.domain.ArquivoJasper;
import br.com.elotech.tributos.dto.ComunicadoCadastroDto;
import br.com.elotech.tributos.dto.comunicadocadastro.ComunicadoCadastroGeraBoletoRequest;
import br.com.elotech.tributos.dto.comunicadocadastro.ComunicadoEfetividadeNotificacoesDTO;
import br.com.elotech.tributos.dto.comunicadocadastro.ComunicadoEfetividadeNotificacoesFilterDTO;
import br.com.elotech.tributos.dto.comunicadocadastro.ComunicadoEfetividadeRelatorioDTO;
import br.com.elotech.tributos.enums.TipoArquivoJasper;
import br.com.elotech.tributos.report.loader.ExtratoDebitoParamLoader;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.ArquivoJasperService;
import br.com.elotech.tributos.service.comunicado.ComunicadoCadastroService;
import br.com.elotech.tributos.util.JasperUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api/comunicados-cadastros"})
public class ComunicadoCadastroResource {
    private final ComunicadoCadastroService comunicadoCadastroService;
    private final ArquivoJasperService arquivoJasperService;
    private final ObjectMapper objectMapper;
    private final ExtratoDebitoParamLoader extratoDebitoParamLoader;

    @GetMapping(value={"/{entidade}/{exercicio}/{idComunicado}"})
    public ResponseEntity<Page<ComunicadoCadastroDto>> searchComunicadoCadastro(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long idComunicado, @RequestParam(value="search", required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.comunicadoCadastroService.findByRsqlComunicadoCadastro(entidade, exercicio, idComunicado, search, pageable));
    }

    @PutMapping(value={"/{entidade}/{exercicio}/{idComunicado}/{sequencia}/cancelar"})
    public ResponseEntity<ComunicadoCadastroDto> cancelaComunicadoCadastro(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long idComunicado, @PathVariable Long sequencia) {
        return ResponseEntity.ok((Object)this.comunicadoCadastroService.cancelaComunicadoCadastro(entidade, exercicio, idComunicado, sequencia));
    }

    @PutMapping(value={"/{entidade}/{exercicio}/{idComunicado}/{sequencia}/valida-endereco"})
    public ResponseEntity<ComunicadoCadastroDto> validateEnderecoNotificacao(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long idComunicado, @PathVariable Long sequencia) {
        return ResponseEntity.ok((Object)this.comunicadoCadastroService.validateEnderecoNotificacao(entidade, exercicio, idComunicado, sequencia));
    }

    @GetMapping(value={"/{entidade}/{exercicio}/{idComunicado}/{sequencia}/imprimir"})
    public void print(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long idComunicado, @PathVariable Long sequencia, HttpServletResponse response) throws IOException {
        byte[] file = this.comunicadoCadastroService.print(entidade, exercicio, idComunicado, sequencia);
        ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])file, (String)"comunicado.pdf");
    }

    @PostMapping(value={"/{entidade}/{exercicio}/{idComunicado}/{sequencia}/gerar-boleto"})
    public ResponseEntity<Void> gerarBoleto(@RequestBody @Valid ComunicadoCadastroGeraBoletoRequest request) {
        this.comunicadoCadastroService.gerarBloqueto(request);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/efetividade-notificacoes"})
    public ResponseEntity<ComunicadoEfetividadeRelatorioDTO> getEfetividadeNotificacoes(@RequestBody ComunicadoEfetividadeNotificacoesFilterDTO filterDTO, Pageable pageable) {
        return ResponseEntity.ok((Object)this.comunicadoCadastroService.efetividadeNotificacoesComunicadoCadastro(filterDTO, pageable));
    }

    @PostMapping(value={"/efetividade-notificacoes/imprimir"})
    public ResponseEntity<byte[]> printEfetividadeNotificacoes(@RequestBody ComunicadoEfetividadeNotificacoesFilterDTO filtro, @RequestParam(value="reportType") String reportType) throws IOException {
        byte[] fileBytes;
        String fileExtension = Objects.equals(reportType, "pdf") ? "pdf" : "csv";
        String contentType = Objects.equals(reportType, "pdf") ? "application/pdf" : "text/csv";
        ArquivoJasper arquivoJasper = this.arquivoJasperService.buscarArquivoJasperPorTipo(TipoArquivoJasper.EFETIVIDADE_NOTIFICACOES);
        String filePath = JasperUtils.geraCaminhoArquivoJasper((ArquivoJasper)arquivoJasper, (String)"efetividade-notificacoes.jrxml");
        ComunicadoEfetividadeRelatorioDTO comunicadoEfetividadeRelatorioDTO = this.comunicadoCadastroService.efetividadeNotificacoesComunicadoCadastro(filtro, Pageable.unpaged());
        DatasetLoader mainDatasetLoader = DatasetLoaders.fromRecords((List)comunicadoEfetividadeRelatorioDTO.getDados().getContent(), ComunicadoEfetividadeNotificacoesDTO.class);
        ReportDatasource datasource = ReportDatasource.builder().add("main", (ReportDataLoader)mainDatasetLoader).params((ParamLoader)this.extratoDebitoParamLoader).param(Param.of((String)"totalValorNotificacao", (Object)Optional.ofNullable(comunicadoEfetividadeRelatorioDTO.getTotalValorNotificacao()).orElse(BigDecimal.ZERO))).param(Param.of((String)"totalValorPagoAposNotificacao", (Object)Optional.ofNullable(comunicadoEfetividadeRelatorioDTO.getTotalValorPagoAposNotificacao()).orElse(BigDecimal.ZERO))).param(Param.of((String)"totalRegistros", (Object)Optional.ofNullable(comunicadoEfetividadeRelatorioDTO.getTotalRegistros()).orElse(0L))).param(Param.of((String)"USUARIO", (Object)SecurityUtils.getUserAise())).param(Param.of((String)"FILTRO", (Object)filtro.getDescricaoFiltro())).build();
        EloReport report = EloReportFactory.jasper().reportFile(new ReportFileResolverFactory("").fromFile(filePath)).setReportDatasource(datasource).setObjectMapper(this.objectMapper).build();
        byte[] byArray = fileBytes = Objects.equals(reportType, "pdf") ? report.exportToPdf() : report.exportToCsv();
        if (Objects.nonNull(arquivoJasper)) {
            Files.deleteIfExists(Paths.get(filePath, new String[0]));
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)contentType));
        headers.setContentDisposition(ContentDisposition.builder((String)"attachment").filename("efetividade-notificacoes." + fileExtension).build());
        headers.setContentLength((long)fileBytes.length);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)fileBytes);
    }

    @Generated
    public ComunicadoCadastroResource(ComunicadoCadastroService comunicadoCadastroService, ArquivoJasperService arquivoJasperService, ObjectMapper objectMapper, ExtratoDebitoParamLoader extratoDebitoParamLoader) {
        this.comunicadoCadastroService = comunicadoCadastroService;
        this.arquivoJasperService = arquivoJasperService;
        this.objectMapper = objectMapper;
        this.extratoDebitoParamLoader = extratoDebitoParamLoader;
    }
}

