/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.utils.web.ResponseUtils;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.protesto.Protesto;
import br.com.elotech.tributos.dto.CertidaoDividaAtivaAvulsaDTO;
import br.com.elotech.tributos.dto.DebitosCdaDTO;
import br.com.elotech.tributos.dto.DocumentoDTO;
import br.com.elotech.tributos.dto.ImprimirRelatorioDTO;
import br.com.elotech.tributos.dto.certidaodividaativa.AtualizaNumeroProcessoJudicialDTO;
import br.com.elotech.tributos.dto.certidaodividaativa.ImpressaoExtratoCdaDTO;
import br.com.elotech.tributos.dto.documento.SituacaoDocumentoDTO;
import br.com.elotech.tributos.dto.documento.cda.AtualizaItensParcelasDTO;
import br.com.elotech.tributos.resource.RelatorioResource;
import br.com.elotech.tributos.service.ArquivoUnicoService;
import br.com.elotech.tributos.service.CertidaoDividaAtivaService;
import br.com.elotech.tributos.service.DocumentoItemDividaAtivaService;
import br.com.elotech.tributos.service.DocumentoService;
import br.com.elotech.tributos.service.documento.cda.GeraCertidaoDividaAtivaService;
import br.com.elotech.tributos.service.ws.AiseRelatorioService;
import java.io.IOException;
import java.io.Serializable;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/certidoes-divida-ativa"})
@Transactional(readOnly=true)
public class CertidaoDividaAtivaResource {
    private final CertidaoDividaAtivaService certidaoDividaAtivaService;
    private final RelatorioResource relatorioResource;
    private final DocumentoItemDividaAtivaService documentoItemDividaAtivaService;
    private final DocumentoService documentoService;
    private final ArquivoUnicoService arquivoUnicoService;
    private final GeraCertidaoDividaAtivaService geraCertidaoDividaAtivaService;
    private final AiseRelatorioService aiseRelatorioService;

    public CertidaoDividaAtivaResource(CertidaoDividaAtivaService certidaoDividaAtivaService, RelatorioResource relatorioResource, DocumentoItemDividaAtivaService documentoItemDividaAtivaService, DocumentoService documentoService, ArquivoUnicoService arquivoUnicoService, GeraCertidaoDividaAtivaService geraCertidaoDividaAtivaService, AiseRelatorioService aiseRelatorioService) {
        this.certidaoDividaAtivaService = certidaoDividaAtivaService;
        this.relatorioResource = relatorioResource;
        this.documentoItemDividaAtivaService = documentoItemDividaAtivaService;
        this.documentoService = documentoService;
        this.arquivoUnicoService = arquivoUnicoService;
        this.geraCertidaoDividaAtivaService = geraCertidaoDividaAtivaService;
        this.aiseRelatorioService = aiseRelatorioService;
    }

    @GetMapping(value={"/{id}/resumo"})
    public ResponseEntity<DocumentoDTO> findDocumentosDividaAtiva(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.certidaoDividaAtivaService.findDocumentosDividaAtiva(id));
    }

    @Transactional
    @PutMapping(value={"{id}/cancelar"})
    public ResponseEntity<DocumentoDTO> cancelarCda(@PathVariable Long id, @RequestBody SituacaoDocumentoDTO cancelamentoDocumentoDTO) {
        return ResponseEntity.ok((Object)this.certidaoDividaAtivaService.cancelarCda(id, cancelamentoDocumentoDTO));
    }

    @Transactional
    @GetMapping(value={"/{id}/salvar-unico"})
    public ResponseEntity<Long> salvarArquivoUnico(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.certidaoDividaAtivaService.saveArquivoUnico(id));
    }

    @GetMapping(value={"/imprimir-by-cda-exercicio"})
    public byte[] imprimirByCdaAndExercicio(@RequestParam(value="cda") Long cda, @RequestParam(value="exercicio") Long exercicio) {
        Documento documento = this.documentoService.getCdaByExercicioDocumento(exercicio, cda);
        if (documento.getIdArquivoUnico() == null) {
            ImprimirRelatorioDTO imprimirRelatorioDTO = this.certidaoDividaAtivaService.buildImpressaoCDA(documento);
            return this.aiseRelatorioService.imprimirRelatorioGenerico(imprimirRelatorioDTO);
        }
        return this.arquivoUnicoService.baixarPDF(documento.getIdArquivoUnico());
    }

    @GetMapping(value={"/{id}/imprimir"})
    public void getImpirimirCertidoesDividaAtiva(@PathVariable Long id, HttpServletResponse response) throws IOException {
        Documento documento = (Documento)this.documentoService.findOne((Serializable)id);
        if (documento.getIdArquivoUnico() == null) {
            ImprimirRelatorioDTO imprimirRelatorioDTO = this.certidaoDividaAtivaService.buildImpressaoCDA(documento);
            this.relatorioResource.imprimirRelatorioGenerico(imprimirRelatorioDTO, response);
        } else {
            byte[] arquivoPDF = this.arquivoUnicoService.baixarPDF(documento.getIdArquivoUnico());
            response.setHeader("Cache-Control", "no-cache, no-store, max-age=0, must-revalidate");
            response.setHeader("Expires", "0");
            response.setHeader("Pragma", "no-cache");
            response.setContentType("application/pdf");
            response.setContentLength(arquivoPDF.length);
            response.getOutputStream().write(arquivoPDF);
        }
    }

    @GetMapping(value={"/search"})
    public ResponseEntity<Page<DocumentoDTO>> findAllDocumentoDividaAtiva(@RequestParam Optional<String> search, Pageable page) {
        return ResponseEntity.ok((Object)this.certidaoDividaAtivaService.getDocumentos(search, page));
    }

    @Transactional
    @PutMapping(value={"/{id}/atualiza-itens-parcelas"})
    public ResponseEntity<Void> atualizaItensParcelas(@PathVariable Long id, @Valid @RequestBody AtualizaItensParcelasDTO dto) {
        this.documentoItemDividaAtivaService.atualizaItensParcelas(id, dto);
        return ResponseEntity.noContent().build();
    }

    @Transactional
    @PostMapping(value={"/avulsa"})
    public ResponseEntity<Documento> saveCertidaoDividaAtivaAvulsa(@RequestBody CertidaoDividaAtivaAvulsaDTO certidaoDividaAtivaAvulsaDTO) {
        return ResponseEntity.ok((Object)this.geraCertidaoDividaAtivaService.gerarCertidaoDividaAtivaAvulsa(certidaoDividaAtivaAvulsaDTO));
    }

    @GetMapping(value={"/verifica-cda-existente"})
    public ResponseEntity<Boolean> existsDocumentoCDA(@RequestParam Long numero, @RequestParam Long exercicio) {
        return ResponseEntity.ok((Object)this.documentoService.existsDocumentoCDA(numero, exercicio));
    }

    @Transactional
    @PostMapping(value={"/protestar-cda/{idCda}"})
    public ResponseEntity<Protesto> protestarCda(@PathVariable Long idCda) {
        return ResponseEntity.ok((Object)this.certidaoDividaAtivaService.protestarCda(idCda));
    }

    @Transactional
    @PostMapping(value={"incluir-debitos"})
    public ResponseEntity<Void> incluiDebitosCda(@RequestBody DebitosCdaDTO debitos) {
        this.geraCertidaoDividaAtivaService.incluiDebitosCda(debitos);
        return ResponseEntity.noContent().build();
    }

    @Transactional
    @PutMapping(value={"/{id}/numero-paf"})
    public ResponseEntity<DocumentoDTO> atualizarNumeroPaf(@PathVariable Long id, @RequestBody(required=false) String numeroPaf) {
        Documento documento = this.certidaoDividaAtivaService.atualizarNumeroPaf(id, numeroPaf);
        return ResponseEntity.ok((Object)DocumentoDTO.from((Documento)documento));
    }

    @PutMapping(value={"/numero-processo-judicial"})
    public ResponseEntity<Void> atualizarNumeroProcessoJudicial(@RequestBody AtualizaNumeroProcessoJudicialDTO dto) {
        this.certidaoDividaAtivaService.atualizaNumeroProcessoJudicial(dto);
        return ResponseEntity.accepted().build();
    }

    @PostMapping(value={"/imprimir-extrato"})
    public void imprimirExtrato(@RequestBody ImpressaoExtratoCdaDTO filtro, HttpServletResponse response) throws IOException {
        byte[] arquivo = this.certidaoDividaAtivaService.imprimirExtrato(filtro);
        if (arquivo == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "N\u00e3o foi poss\u00edvel gerar extrato");
        }
        ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])arquivo, (String)"extrato-cda.pdf");
    }
}

