/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.dto.cadastroimobiliario.CadastroImobiliarioEnglobadoDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.CadastroImobiliarioEnglobadoPostDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.CadastroImobiliarioRowDTO;
import br.com.elotech.tributos.service.CadastroImobiliarioEnglobadoService;
import java.util.List;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cadastro-imobiliario-englobamento"})
public class CadastroImobiliarioEnglobadoResource {
    private final CadastroImobiliarioEnglobadoService cadastroImobiliarioEnglobadoService;

    @GetMapping(value={"/por-cadastro-origem/{id}"})
    public ResponseEntity<CadastroImobiliarioEnglobadoDTO> findEnglobamentoByCadastroOrigem(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.cadastroImobiliarioEnglobadoService.findByCadastroOrigem(id));
    }

    @GetMapping(value={"/imobiliarios-para-englobamento-por-cadastro-origem/{id}"})
    public ResponseEntity<List<CadastroImobiliarioRowDTO>> findImobiliariosAptosParaEnglobamentoByImobiliarioOrigem(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.cadastroImobiliarioEnglobadoService.findImobiliariosAptosParaEnglobamentoByImobiliarioOrigem(id));
    }

    @PostMapping
    public ResponseEntity<CadastroImobiliarioEnglobadoDTO> save(@RequestBody @Valid CadastroImobiliarioEnglobadoPostDTO dto) {
        return ResponseEntity.ok((Object)this.cadastroImobiliarioEnglobadoService.create(dto));
    }

    @DeleteMapping(value={"/{idEnglobamento}"})
    public ResponseEntity<Void> delete(@PathVariable Long idEnglobamento) {
        this.cadastroImobiliarioEnglobadoService.delete(idEnglobamento);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/cadastro-ja-englobado/{idCadastro}"})
    public ResponseEntity<Void> validaSeCadastroJaEstaEnglobado(@PathVariable Long idCadastro) {
        this.cadastroImobiliarioEnglobadoService.validaSeCadastroJaEstaEnglobadoByIdCadastro(idCadastro);
        return ResponseEntity.ok().build();
    }

    @Generated
    public CadastroImobiliarioEnglobadoResource(CadastroImobiliarioEnglobadoService cadastroImobiliarioEnglobadoService) {
        this.cadastroImobiliarioEnglobadoService = cadastroImobiliarioEnglobadoService;
    }
}

