/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.dto.AlvaraLocalizacaoDTO;
import br.com.elotech.tributos.dto.DocumentoDTO;
import br.com.elotech.tributos.dto.DocumentoSearchInitialValuesDTO;
import br.com.elotech.tributos.dto.ImpressaoDTO;
import br.com.elotech.tributos.service.AlvaraLocalizacaoService;
import br.com.elotech.tributos.service.DocumentoService;
import java.io.IOException;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/alvara-localizacao"})
public class AlvaraLocalizacaoResource {
    private final AlvaraLocalizacaoService alvaraLocalizacaoService;
    private final DocumentoService documentoService;

    @PostMapping(value={"/valores-iniciais"})
    public ResponseEntity<AlvaraLocalizacaoDTO> getInitialValues(@RequestBody DocumentoSearchInitialValuesDTO documentoSearchInitialValuesDTO) {
        return ResponseEntity.ok((Object)this.alvaraLocalizacaoService.getInitialValues(documentoSearchInitialValuesDTO));
    }

    @PostMapping
    public ResponseEntity<ImpressaoDTO> save(@RequestBody @Valid AlvaraLocalizacaoDTO geracaoDocumentoDto) throws IOException {
        DocumentoDTO dto = this.alvaraLocalizacaoService.save(geracaoDocumentoDto);
        return ResponseEntity.ok((Object)this.documentoService.imprimirDocumento(dto.getId(), geracaoDocumentoDto.getRelatorioImpressao(), Boolean.FALSE));
    }

    @PutMapping(value={"/{id}/editar"})
    public ResponseEntity<ImpressaoDTO> editar(@PathVariable(value="id") Long id, @RequestBody @Valid AlvaraLocalizacaoDTO geracaoDocumentoDto) throws IOException {
        DocumentoDTO dto = this.alvaraLocalizacaoService.editar(id, geracaoDocumentoDto);
        return ResponseEntity.ok((Object)this.documentoService.imprimirDocumento(dto.getId(), geracaoDocumentoDto.getRelatorioImpressao(), Boolean.TRUE));
    }

    @Generated
    public AlvaraLocalizacaoResource(AlvaraLocalizacaoService alvaraLocalizacaoService, DocumentoService documentoService) {
        this.alvaraLocalizacaoService = alvaraLocalizacaoService;
        this.documentoService = documentoService;
    }
}

